/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an entity.
 * </p>
 * <p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Entity implements SdkPojo, Serializable, ToCopyableBuilder<Entity.Builder, Entity> {
    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(Entity::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Entity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(Entity::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffset").getter(getter(Entity::beginOffset)).setter(setter(Builder::beginOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()).build();

    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffset").getter(getter(Entity::endOffset)).setter(setter(Builder::endOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_FIELD, TYPE_FIELD,
            TEXT_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float score;

    private final String type;

    private final String text;

    private final Integer beginOffset;

    private final Integer endOffset;

    private Entity(BuilderImpl builder) {
        this.score = builder.score;
        this.type = builder.type;
        this.text = builder.text;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     */
    public final Float score() {
        return score;
    }

    /**
     * <p>
     * The entity's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The entity's type.
     * @see EntityType
     */
    public final EntityType type() {
        return EntityType.fromValue(type);
    }

    /**
     * <p>
     * The entity's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The entity's type.
     * @see EntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The text of the entity.
     * </p>
     * 
     * @return The text of the entity.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * A character offset in the input text that shows where the entity begins (the first character is at position 0).
     * The offset returns the position of each UTF-8 code point in the string. A <i>code point</i> is the abstract
     * character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single
     * code point.
     * </p>
     * 
     * @return A character offset in the input text that shows where the entity begins (the first character is at
     *         position 0). The offset returns the position of each UTF-8 code point in the string. A <i>code point</i>
     *         is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8
     *         character maps to a single code point.
     */
    public final Integer beginOffset() {
        return beginOffset;
    }

    /**
     * <p>
     * A character offset in the input text that shows where the entity ends. The offset returns the position of each
     * UTF-8 code point in the string. A <i>code point</i> is the abstract character from a particular graphical
     * representation. For example, a multi-byte UTF-8 character maps to a single code point.
     * </p>
     * 
     * @return A character offset in the input text that shows where the entity ends. The offset returns the position of
     *         each UTF-8 code point in the string. A <i>code point</i> is the abstract character from a particular
     *         graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
     */
    public final Integer endOffset() {
        return endOffset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endOffset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity) obj;
        return Objects.equals(score(), other.score()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(text(), other.text()) && Objects.equals(beginOffset(), other.beginOffset())
                && Objects.equals(endOffset(), other.endOffset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Entity").add("Score", score()).add("Type", typeAsString()).add("Text", text())
                .add("BeginOffset", beginOffset()).add("EndOffset", endOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "BeginOffset":
            return Optional.ofNullable(clazz.cast(beginOffset()));
        case "EndOffset":
            return Optional.ofNullable(clazz.cast(endOffset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Entity> {
        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         * </p>
         * 
         * @param score
         *        The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);

        /**
         * <p>
         * The entity's type.
         * </p>
         * 
         * @param type
         *        The entity's type.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(String type);

        /**
         * <p>
         * The entity's type.
         * </p>
         * 
         * @param type
         *        The entity's type.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(EntityType type);

        /**
         * <p>
         * The text of the entity.
         * </p>
         * 
         * @param text
         *        The text of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * A character offset in the input text that shows where the entity begins (the first character is at position
         * 0). The offset returns the position of each UTF-8 code point in the string. A <i>code point</i> is the
         * abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps
         * to a single code point.
         * </p>
         * 
         * @param beginOffset
         *        A character offset in the input text that shows where the entity begins (the first character is at
         *        position 0). The offset returns the position of each UTF-8 code point in the string. A <i>code
         *        point</i> is the abstract character from a particular graphical representation. For example, a
         *        multi-byte UTF-8 character maps to a single code point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffset(Integer beginOffset);

        /**
         * <p>
         * A character offset in the input text that shows where the entity ends. The offset returns the position of
         * each UTF-8 code point in the string. A <i>code point</i> is the abstract character from a particular
         * graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
         * </p>
         * 
         * @param endOffset
         *        A character offset in the input text that shows where the entity ends. The offset returns the position
         *        of each UTF-8 code point in the string. A <i>code point</i> is the abstract character from a
         *        particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code
         *        point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffset(Integer endOffset);
    }

    static final class BuilderImpl implements Builder {
        private Float score;

        private String type;

        private String text;

        private Integer beginOffset;

        private Integer endOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            score(model.score);
            type(model.type);
            text(model.text);
            beginOffset(model.beginOffset);
            endOffset(model.endOffset);
        }

        public final Float getScore() {
            return score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Integer getBeginOffset() {
            return beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public Entity build() {
            return new Entity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
