/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectDominantLanguageResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectDominantLanguageResponse.Builder, DetectDominantLanguageResponse> {
    private static final SdkField<List<DominantLanguage>> LANGUAGES_FIELD = SdkField
            .<List<DominantLanguage>> builder(MarshallingType.LIST)
            .memberName("Languages")
            .getter(getter(DetectDominantLanguageResponse::languages))
            .setter(setter(Builder::languages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DominantLanguage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DominantLanguage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGES_FIELD));

    private final List<DominantLanguage> languages;

    private DetectDominantLanguageResponse(BuilderImpl builder) {
        super(builder);
        this.languages = builder.languages;
    }

    /**
     * Returns true if the Languages property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLanguages() {
        return languages != null && !(languages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The languages that Amazon Comprehend detected in the input text. For each language, the response returns the RFC
     * 5646 language code and the level of confidence that Amazon Comprehend has in the accuracy of its inference. For
     * more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for Identifying
     * Languages</a> on the <i>IETF Tools</i> web site.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLanguages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The languages that Amazon Comprehend detected in the input text. For each language, the response returns
     *         the RFC 5646 language code and the level of confidence that Amazon Comprehend has in the accuracy of its
     *         inference. For more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags
     *         for Identifying Languages</a> on the <i>IETF Tools</i> web site.
     */
    public final List<DominantLanguage> languages() {
        return languages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguages() ? languages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDominantLanguageResponse)) {
            return false;
        }
        DetectDominantLanguageResponse other = (DetectDominantLanguageResponse) obj;
        return hasLanguages() == other.hasLanguages() && Objects.equals(languages(), other.languages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectDominantLanguageResponse").add("Languages", hasLanguages() ? languages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Languages":
            return Optional.ofNullable(clazz.cast(languages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectDominantLanguageResponse, T> g) {
        return obj -> g.apply((DetectDominantLanguageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectDominantLanguageResponse> {
        /**
         * <p>
         * The languages that Amazon Comprehend detected in the input text. For each language, the response returns the
         * RFC 5646 language code and the level of confidence that Amazon Comprehend has in the accuracy of its
         * inference. For more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for
         * Identifying Languages</a> on the <i>IETF Tools</i> web site.
         * </p>
         * 
         * @param languages
         *        The languages that Amazon Comprehend detected in the input text. For each language, the response
         *        returns the RFC 5646 language code and the level of confidence that Amazon Comprehend has in the
         *        accuracy of its inference. For more information about RFC 5646, see <a
         *        href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i>
         *        web site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(Collection<DominantLanguage> languages);

        /**
         * <p>
         * The languages that Amazon Comprehend detected in the input text. For each language, the response returns the
         * RFC 5646 language code and the level of confidence that Amazon Comprehend has in the accuracy of its
         * inference. For more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for
         * Identifying Languages</a> on the <i>IETF Tools</i> web site.
         * </p>
         * 
         * @param languages
         *        The languages that Amazon Comprehend detected in the input text. For each language, the response
         *        returns the RFC 5646 language code and the level of confidence that Amazon Comprehend has in the
         *        accuracy of its inference. For more information about RFC 5646, see <a
         *        href="https://tools.ietf.org/html/rfc5646">Tags for Identifying Languages</a> on the <i>IETF Tools</i>
         *        web site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(DominantLanguage... languages);

        /**
         * <p>
         * The languages that Amazon Comprehend detected in the input text. For each language, the response returns the
         * RFC 5646 language code and the level of confidence that Amazon Comprehend has in the accuracy of its
         * inference. For more information about RFC 5646, see <a href="https://tools.ietf.org/html/rfc5646">Tags for
         * Identifying Languages</a> on the <i>IETF Tools</i> web site.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DominantLanguage>.Builder} avoiding the
         * need to create one manually via {@link List<DominantLanguage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DominantLanguage>.Builder#build()} is called immediately and
         * its result is passed to {@link #languages(List<DominantLanguage>)}.
         * 
         * @param languages
         *        a consumer that will call methods on {@link List<DominantLanguage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #languages(List<DominantLanguage>)
         */
        Builder languages(Consumer<DominantLanguage.Builder>... languages);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<DominantLanguage> languages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDominantLanguageResponse model) {
            super(model);
            languages(model.languages);
        }

        public final Collection<DominantLanguage.Builder> getLanguages() {
            if (languages instanceof SdkAutoConstructList) {
                return null;
            }
            return languages != null ? languages.stream().map(DominantLanguage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder languages(Collection<DominantLanguage> languages) {
            this.languages = ListOfDominantLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(DominantLanguage... languages) {
            languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<DominantLanguage.Builder>... languages) {
            languages(Stream.of(languages).map(c -> DominantLanguage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLanguages(Collection<DominantLanguage.BuilderImpl> languages) {
            this.languages = ListOfDominantLanguagesCopier.copyFromBuilder(languages);
        }

        @Override
        public DetectDominantLanguageResponse build() {
            return new DetectDominantLanguageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
