/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntitiesDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeEntitiesDetectionJobResponse.Builder, DescribeEntitiesDetectionJobResponse> {
    private static final SdkField<EntitiesDetectionJobProperties> ENTITIES_DETECTION_JOB_PROPERTIES_FIELD = SdkField
            .<EntitiesDetectionJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("EntitiesDetectionJobProperties")
            .getter(getter(DescribeEntitiesDetectionJobResponse::entitiesDetectionJobProperties))
            .setter(setter(Builder::entitiesDetectionJobProperties))
            .constructor(EntitiesDetectionJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitiesDetectionJobProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENTITIES_DETECTION_JOB_PROPERTIES_FIELD));

    private final EntitiesDetectionJobProperties entitiesDetectionJobProperties;

    private DescribeEntitiesDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.entitiesDetectionJobProperties = builder.entitiesDetectionJobProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with an entities detection job.
     * </p>
     * 
     * @return An object that contains the properties associated with an entities detection job.
     */
    public final EntitiesDetectionJobProperties entitiesDetectionJobProperties() {
        return entitiesDetectionJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entitiesDetectionJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntitiesDetectionJobResponse)) {
            return false;
        }
        DescribeEntitiesDetectionJobResponse other = (DescribeEntitiesDetectionJobResponse) obj;
        return Objects.equals(entitiesDetectionJobProperties(), other.entitiesDetectionJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEntitiesDetectionJobResponse")
                .add("EntitiesDetectionJobProperties", entitiesDetectionJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntitiesDetectionJobProperties":
            return Optional.ofNullable(clazz.cast(entitiesDetectionJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntitiesDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribeEntitiesDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEntitiesDetectionJobResponse> {
        /**
         * <p>
         * An object that contains the properties associated with an entities detection job.
         * </p>
         * 
         * @param entitiesDetectionJobProperties
         *        An object that contains the properties associated with an entities detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesDetectionJobProperties(EntitiesDetectionJobProperties entitiesDetectionJobProperties);

        /**
         * <p>
         * An object that contains the properties associated with an entities detection job.
         * </p>
         * This is a convenience that creates an instance of the {@link EntitiesDetectionJobProperties.Builder} avoiding
         * the need to create one manually via {@link EntitiesDetectionJobProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntitiesDetectionJobProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #entitiesDetectionJobProperties(EntitiesDetectionJobProperties)}.
         * 
         * @param entitiesDetectionJobProperties
         *        a consumer that will call methods on {@link EntitiesDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitiesDetectionJobProperties(EntitiesDetectionJobProperties)
         */
        default Builder entitiesDetectionJobProperties(
                Consumer<EntitiesDetectionJobProperties.Builder> entitiesDetectionJobProperties) {
            return entitiesDetectionJobProperties(EntitiesDetectionJobProperties.builder()
                    .applyMutation(entitiesDetectionJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private EntitiesDetectionJobProperties entitiesDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntitiesDetectionJobResponse model) {
            super(model);
            entitiesDetectionJobProperties(model.entitiesDetectionJobProperties);
        }

        public final EntitiesDetectionJobProperties.Builder getEntitiesDetectionJobProperties() {
            return entitiesDetectionJobProperties != null ? entitiesDetectionJobProperties.toBuilder() : null;
        }

        @Override
        public final Builder entitiesDetectionJobProperties(EntitiesDetectionJobProperties entitiesDetectionJobProperties) {
            this.entitiesDetectionJobProperties = entitiesDetectionJobProperties;
            return this;
        }

        public final void setEntitiesDetectionJobProperties(
                EntitiesDetectionJobProperties.BuilderImpl entitiesDetectionJobProperties) {
            this.entitiesDetectionJobProperties = entitiesDetectionJobProperties != null ? entitiesDetectionJobProperties.build()
                    : null;
        }

        @Override
        public DescribeEntitiesDetectionJobResponse build() {
            return new DescribeEntitiesDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
