/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectSentimentResponse extends ComprehendResponse implements
        ToCopyableBuilder<BatchDetectSentimentResponse.Builder, BatchDetectSentimentResponse> {
    private static final SdkField<List<BatchDetectSentimentItemResult>> RESULT_LIST_FIELD = SdkField
            .<List<BatchDetectSentimentItemResult>> builder(MarshallingType.LIST)
            .memberName("ResultList")
            .getter(getter(BatchDetectSentimentResponse::resultList))
            .setter(setter(Builder::resultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDetectSentimentItemResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDetectSentimentItemResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchItemError>> ERROR_LIST_FIELD = SdkField
            .<List<BatchItemError>> builder(MarshallingType.LIST)
            .memberName("ErrorList")
            .getter(getter(BatchDetectSentimentResponse::errorList))
            .setter(setter(Builder::errorList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchItemError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchItemError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD,
            ERROR_LIST_FIELD));

    private final List<BatchDetectSentimentItemResult> resultList;

    private final List<BatchItemError> errorList;

    private BatchDetectSentimentResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    /**
     * Returns true if the ResultList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResultList() {
        return resultList != null && !(resultList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the results of the operation. The results are sorted in ascending order by the
     * <code>Index</code> field and match the order of the documents in the input list. If all of the documents contain
     * an error, the <code>ResultList</code> is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResultList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects containing the results of the operation. The results are sorted in ascending order by
     *         the <code>Index</code> field and match the order of the documents in the input list. If all of the
     *         documents contain an error, the <code>ResultList</code> is empty.
     */
    public final List<BatchDetectSentimentItemResult> resultList() {
        return resultList;
    }

    /**
     * Returns true if the ErrorList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrorList() {
        return errorList != null && !(errorList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing one object for each document that contained an error. The results are sorted in ascending order
     * by the <code>Index</code> field and match the order of the documents in the input list. If there are no errors in
     * the batch, the <code>ErrorList</code> is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrorList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list containing one object for each document that contained an error. The results are sorted in
     *         ascending order by the <code>Index</code> field and match the order of the documents in the input list.
     *         If there are no errors in the batch, the <code>ErrorList</code> is empty.
     */
    public final List<BatchItemError> errorList() {
        return errorList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResultList() ? resultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorList() ? errorList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentResponse)) {
            return false;
        }
        BatchDetectSentimentResponse other = (BatchDetectSentimentResponse) obj;
        return hasResultList() == other.hasResultList() && Objects.equals(resultList(), other.resultList())
                && hasErrorList() == other.hasErrorList() && Objects.equals(errorList(), other.errorList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDetectSentimentResponse").add("ResultList", hasResultList() ? resultList() : null)
                .add("ErrorList", hasErrorList() ? errorList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultList":
            return Optional.ofNullable(clazz.cast(resultList()));
        case "ErrorList":
            return Optional.ofNullable(clazz.cast(errorList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSentimentResponse, T> g) {
        return obj -> g.apply((BatchDetectSentimentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDetectSentimentResponse> {
        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * 
         * @param resultList
         *        A list of objects containing the results of the operation. The results are sorted in ascending order
         *        by the <code>Index</code> field and match the order of the documents in the input list. If all of the
         *        documents contain an error, the <code>ResultList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(Collection<BatchDetectSentimentItemResult> resultList);

        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * 
         * @param resultList
         *        A list of objects containing the results of the operation. The results are sorted in ascending order
         *        by the <code>Index</code> field and match the order of the documents in the input list. If all of the
         *        documents contain an error, the <code>ResultList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultList(BatchDetectSentimentItemResult... resultList);

        /**
         * <p>
         * A list of objects containing the results of the operation. The results are sorted in ascending order by the
         * <code>Index</code> field and match the order of the documents in the input list. If all of the documents
         * contain an error, the <code>ResultList</code> is empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchDetectSentimentItemResult>.Builder}
         * avoiding the need to create one manually via {@link List<BatchDetectSentimentItemResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchDetectSentimentItemResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #resultList(List<BatchDetectSentimentItemResult>)}.
         * 
         * @param resultList
         *        a consumer that will call methods on {@link List<BatchDetectSentimentItemResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultList(List<BatchDetectSentimentItemResult>)
         */
        Builder resultList(Consumer<BatchDetectSentimentItemResult.Builder>... resultList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * 
         * @param errorList
         *        A list containing one object for each document that contained an error. The results are sorted in
         *        ascending order by the <code>Index</code> field and match the order of the documents in the input
         *        list. If there are no errors in the batch, the <code>ErrorList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(Collection<BatchItemError> errorList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * 
         * @param errorList
         *        A list containing one object for each document that contained an error. The results are sorted in
         *        ascending order by the <code>Index</code> field and match the order of the documents in the input
         *        list. If there are no errors in the batch, the <code>ErrorList</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(BatchItemError... errorList);

        /**
         * <p>
         * A list containing one object for each document that contained an error. The results are sorted in ascending
         * order by the <code>Index</code> field and match the order of the documents in the input list. If there are no
         * errors in the batch, the <code>ErrorList</code> is empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchItemError>.Builder} avoiding the need
         * to create one manually via {@link List<BatchItemError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchItemError>.Builder#build()} is called immediately and
         * its result is passed to {@link #errorList(List<BatchItemError>)}.
         * 
         * @param errorList
         *        a consumer that will call methods on {@link List<BatchItemError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorList(List<BatchItemError>)
         */
        Builder errorList(Consumer<BatchItemError.Builder>... errorList);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<BatchDetectSentimentItemResult> resultList = DefaultSdkAutoConstructList.getInstance();

        private List<BatchItemError> errorList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentResponse model) {
            super(model);
            resultList(model.resultList);
            errorList(model.errorList);
        }

        public final Collection<BatchDetectSentimentItemResult.Builder> getResultList() {
            if (resultList instanceof SdkAutoConstructList) {
                return null;
            }
            return resultList != null ? resultList.stream().map(BatchDetectSentimentItemResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultList(Collection<BatchDetectSentimentItemResult> resultList) {
            this.resultList = ListOfDetectSentimentResultCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(BatchDetectSentimentItemResult... resultList) {
            resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<BatchDetectSentimentItemResult.Builder>... resultList) {
            resultList(Stream.of(resultList).map(c -> BatchDetectSentimentItemResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResultList(Collection<BatchDetectSentimentItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectSentimentResultCopier.copyFromBuilder(resultList);
        }

        public final Collection<BatchItemError.Builder> getErrorList() {
            if (errorList instanceof SdkAutoConstructList) {
                return null;
            }
            return errorList != null ? errorList.stream().map(BatchItemError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(BatchItemError... errorList) {
            errorList(Arrays.asList(errorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(Consumer<BatchItemError.Builder>... errorList) {
            errorList(Stream.of(errorList).map(c -> BatchItemError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public BatchDetectSentimentResponse build() {
            return new BatchDetectSentimentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
