/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectEntitiesRequest extends ComprehendRequest implements
        ToCopyableBuilder<DetectEntitiesRequest.Builder, DetectEntitiesRequest> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(DetectEntitiesRequest::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(DetectEntitiesRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(DetectEntitiesRequest::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD,
            LANGUAGE_CODE_FIELD, ENDPOINT_ARN_FIELD));

    private final String text;

    private final String languageCode;

    private final String endpointArn;

    private DetectEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.text = builder.text;
        this.languageCode = builder.languageCode;
        this.endpointArn = builder.endpointArn;
    }

    /**
     * <p>
     * A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.
     * </p>
     * 
     * @return A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. All documents must be in the same language.</p>
     *         <p>
     *         If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
     *         language of your custom model, and it ignores any language code that you specify here.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. All documents must be in the same language.</p>
     *         <p>
     *         If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
     *         language of your custom model, and it ignores any language code that you specify here.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
     * endpoint if you want to detect entities by using your own custom model instead of the default model that is used
     * by Amazon Comprehend.
     * </p>
     * <p>
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language
     * code that you provide in your request.
     * </p>
     * 
     * @return The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model.
     *         Provide an endpoint if you want to detect entities by using your own custom model instead of the default
     *         model that is used by Amazon Comprehend.</p>
     *         <p>
     *         If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any
     *         language code that you provide in your request.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesRequest)) {
            return false;
        }
        DetectEntitiesRequest other = (DetectEntitiesRequest) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(endpointArn(), other.endpointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectEntitiesRequest").add("Text", text() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LanguageCode", languageCodeAsString()).add("EndpointArn", endpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectEntitiesRequest, T> g) {
        return obj -> g.apply((DetectEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetectEntitiesRequest> {
        /**
         * <p>
         * A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.
         * </p>
         * 
         * @param text
         *        A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8 encoded characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. All documents must be in the same language.
         * </p>
         * <p>
         * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
         * language of your custom model, and it ignores any language code that you specify here.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. All documents must be in the same language.</p>
         *        <p>
         *        If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses
         *        the language of your custom model, and it ignores any language code that you specify here.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language of the input documents. You can specify any of the primary languages supported by Amazon
         * Comprehend. All documents must be in the same language.
         * </p>
         * <p>
         * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
         * language of your custom model, and it ignores any language code that you specify here.
         * </p>
         * 
         * @param languageCode
         *        The language of the input documents. You can specify any of the primary languages supported by Amazon
         *        Comprehend. All documents must be in the same language.</p>
         *        <p>
         *        If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses
         *        the language of your custom model, and it ignores any language code that you specify here.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
         * endpoint if you want to detect entities by using your own custom model instead of the default model that is
         * used by Amazon Comprehend.
         * </p>
         * <p>
         * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any
         * language code that you provide in your request.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model.
         *        Provide an endpoint if you want to detect entities by using your own custom model instead of the
         *        default model that is used by Amazon Comprehend.</p>
         *        <p>
         *        If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores
         *        any language code that you provide in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String text;

        private String languageCode;

        private String endpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectEntitiesRequest model) {
            super(model);
            text(model.text);
            languageCode(model.languageCode);
            endpointArn(model.endpointArn);
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectEntitiesRequest build() {
            return new DetectEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
