/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSentimentDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListSentimentDetectionJobsResponse> {
    private static final SdkField<List<SentimentDetectionJobProperties>> SENTIMENT_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SentimentDetectionJobPropertiesList").getter(ListSentimentDetectionJobsResponse.getter(ListSentimentDetectionJobsResponse::sentimentDetectionJobPropertiesList)).setter(ListSentimentDetectionJobsResponse.setter(Builder::sentimentDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SentimentDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSentimentDetectionJobsResponse.getter(ListSentimentDetectionJobsResponse::nextToken)).setter(ListSentimentDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENTIMENT_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<SentimentDetectionJobProperties> sentimentDetectionJobPropertiesList;
    private final String nextToken;

    private ListSentimentDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.sentimentDetectionJobPropertiesList = builder.sentimentDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSentimentDetectionJobPropertiesList() {
        return this.sentimentDetectionJobPropertiesList != null && !(this.sentimentDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public List<SentimentDetectionJobProperties> sentimentDetectionJobPropertiesList() {
        return this.sentimentDetectionJobPropertiesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentDetectionJobPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSentimentDetectionJobsResponse)) {
            return false;
        }
        ListSentimentDetectionJobsResponse other = (ListSentimentDetectionJobsResponse)((Object)obj);
        return Objects.equals(this.sentimentDetectionJobPropertiesList(), other.sentimentDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSentimentDetectionJobsResponse").add("SentimentDetectionJobPropertiesList", this.sentimentDetectionJobPropertiesList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SentimentDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.sentimentDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSentimentDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListSentimentDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<SentimentDetectionJobProperties> sentimentDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSentimentDetectionJobsResponse model) {
            super(model);
            this.sentimentDetectionJobPropertiesList(model.sentimentDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<SentimentDetectionJobProperties.Builder> getSentimentDetectionJobPropertiesList() {
            return this.sentimentDetectionJobPropertiesList != null ? (Collection)this.sentimentDetectionJobPropertiesList.stream().map(SentimentDetectionJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sentimentDetectionJobPropertiesList(Collection<SentimentDetectionJobProperties> sentimentDetectionJobPropertiesList) {
            this.sentimentDetectionJobPropertiesList = SentimentDetectionJobPropertiesListCopier.copy(sentimentDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sentimentDetectionJobPropertiesList(SentimentDetectionJobProperties ... sentimentDetectionJobPropertiesList) {
            this.sentimentDetectionJobPropertiesList(Arrays.asList(sentimentDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sentimentDetectionJobPropertiesList(Consumer<SentimentDetectionJobProperties.Builder> ... sentimentDetectionJobPropertiesList) {
            this.sentimentDetectionJobPropertiesList(Stream.of(sentimentDetectionJobPropertiesList).map(c -> (SentimentDetectionJobProperties)((SentimentDetectionJobProperties.Builder)SentimentDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSentimentDetectionJobPropertiesList(Collection<SentimentDetectionJobProperties.BuilderImpl> sentimentDetectionJobPropertiesList) {
            this.sentimentDetectionJobPropertiesList = SentimentDetectionJobPropertiesListCopier.copyFromBuilder(sentimentDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSentimentDetectionJobsResponse build() {
            return new ListSentimentDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSentimentDetectionJobsResponse> {
        public Builder sentimentDetectionJobPropertiesList(Collection<SentimentDetectionJobProperties> var1);

        public Builder sentimentDetectionJobPropertiesList(SentimentDetectionJobProperties ... var1);

        public Builder sentimentDetectionJobPropertiesList(Consumer<SentimentDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

