/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DocumentClass;
import software.amazon.awssdk.services.comprehend.model.DocumentLabel;
import software.amazon.awssdk.services.comprehend.model.ListOfClassesCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassifyDocumentResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ClassifyDocumentResponse> {
    private static final SdkField<List<DocumentClass>> CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Classes").getter(ClassifyDocumentResponse.getter(ClassifyDocumentResponse::classes)).setter(ClassifyDocumentResponse.setter(Builder::classes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentClass::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentLabel>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(ClassifyDocumentResponse.getter(ClassifyDocumentResponse::labels)).setter(ClassifyDocumentResponse.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSES_FIELD, LABELS_FIELD));
    private final List<DocumentClass> classes;
    private final List<DocumentLabel> labels;

    private ClassifyDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.classes = builder.classes;
        this.labels = builder.labels;
    }

    public boolean hasClasses() {
        return this.classes != null && !(this.classes instanceof SdkAutoConstructList);
    }

    public List<DocumentClass> classes() {
        return this.classes;
    }

    public boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public List<DocumentLabel> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.classes());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifyDocumentResponse)) {
            return false;
        }
        ClassifyDocumentResponse other = (ClassifyDocumentResponse)((Object)obj);
        return Objects.equals(this.classes(), other.classes()) && Objects.equals(this.labels(), other.labels());
    }

    public String toString() {
        return ToString.builder((String)"ClassifyDocumentResponse").add("Classes", this.classes()).add("Labels", this.labels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Classes": {
                return Optional.ofNullable(clazz.cast(this.classes()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassifyDocumentResponse, T> g) {
        return obj -> g.apply((ClassifyDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DocumentClass> classes = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentLabel> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifyDocumentResponse model) {
            super(model);
            this.classes(model.classes);
            this.labels(model.labels);
        }

        public final Collection<DocumentClass.Builder> getClasses() {
            return this.classes != null ? (Collection)this.classes.stream().map(DocumentClass::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classes(Collection<DocumentClass> classes) {
            this.classes = ListOfClassesCopier.copy(classes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(DocumentClass ... classes) {
            this.classes(Arrays.asList(classes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(Consumer<DocumentClass.Builder> ... classes) {
            this.classes(Stream.of(classes).map(c -> (DocumentClass)((DocumentClass.Builder)DocumentClass.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClasses(Collection<DocumentClass.BuilderImpl> classes) {
            this.classes = ListOfClassesCopier.copyFromBuilder(classes);
        }

        public final Collection<DocumentLabel.Builder> getLabels() {
            return this.labels != null ? (Collection)this.labels.stream().map(DocumentLabel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labels(Collection<DocumentLabel> labels) {
            this.labels = ListOfLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(DocumentLabel ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<DocumentLabel.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (DocumentLabel)((DocumentLabel.Builder)DocumentLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<DocumentLabel.BuilderImpl> labels) {
            this.labels = ListOfLabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public ClassifyDocumentResponse build() {
            return new ClassifyDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ClassifyDocumentResponse> {
        public Builder classes(Collection<DocumentClass> var1);

        public Builder classes(DocumentClass ... var1);

        public Builder classes(Consumer<DocumentClass.Builder> ... var1);

        public Builder labels(Collection<DocumentLabel> var1);

        public Builder labels(DocumentLabel ... var1);

        public Builder labels(Consumer<DocumentLabel.Builder> ... var1);
    }
}

