/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.KeyPhrase;
import software.amazon.awssdk.services.comprehend.model.ListOfKeyPhrasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectKeyPhrasesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectKeyPhrasesResponse> {
    private static final SdkField<List<KeyPhrase>> KEY_PHRASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyPhrases").getter(DetectKeyPhrasesResponse.getter(DetectKeyPhrasesResponse::keyPhrases)).setter(DetectKeyPhrasesResponse.setter(Builder::keyPhrases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyPhrase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PHRASES_FIELD));
    private final List<KeyPhrase> keyPhrases;

    private DetectKeyPhrasesResponse(BuilderImpl builder) {
        super(builder);
        this.keyPhrases = builder.keyPhrases;
    }

    public final boolean hasKeyPhrases() {
        return this.keyPhrases != null && !(this.keyPhrases instanceof SdkAutoConstructList);
    }

    public final List<KeyPhrase> keyPhrases() {
        return this.keyPhrases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPhrases() ? this.keyPhrases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectKeyPhrasesResponse)) {
            return false;
        }
        DetectKeyPhrasesResponse other = (DetectKeyPhrasesResponse)((Object)obj);
        return this.hasKeyPhrases() == other.hasKeyPhrases() && Objects.equals(this.keyPhrases(), other.keyPhrases());
    }

    public final String toString() {
        return ToString.builder((String)"DetectKeyPhrasesResponse").add("KeyPhrases", this.hasKeyPhrases() ? this.keyPhrases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPhrases": {
                return Optional.ofNullable(clazz.cast(this.keyPhrases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectKeyPhrasesResponse, T> g) {
        return obj -> g.apply((DetectKeyPhrasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<KeyPhrase> keyPhrases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectKeyPhrasesResponse model) {
            super(model);
            this.keyPhrases(model.keyPhrases);
        }

        public final Collection<KeyPhrase.Builder> getKeyPhrases() {
            if (this.keyPhrases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyPhrases != null ? (Collection)this.keyPhrases.stream().map(KeyPhrase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPhrases(Collection<KeyPhrase> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copy(keyPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(KeyPhrase ... keyPhrases) {
            this.keyPhrases(Arrays.asList(keyPhrases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(Consumer<KeyPhrase.Builder> ... keyPhrases) {
            this.keyPhrases(Stream.of(keyPhrases).map(c -> (KeyPhrase)((KeyPhrase.Builder)KeyPhrase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPhrases(Collection<KeyPhrase.BuilderImpl> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copyFromBuilder(keyPhrases);
        }

        @Override
        public DetectKeyPhrasesResponse build() {
            return new DetectKeyPhrasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectKeyPhrasesResponse> {
        public Builder keyPhrases(Collection<KeyPhrase> var1);

        public Builder keyPhrases(KeyPhrase ... var1);

        public Builder keyPhrases(Consumer<KeyPhrase.Builder> ... var1);
    }
}

