/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EntitiesDetectionJobProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEntitiesDetectionJobResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DescribeEntitiesDetectionJobResponse> {
    private static final SdkField<EntitiesDetectionJobProperties> ENTITIES_DETECTION_JOB_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntitiesDetectionJobProperties").getter(DescribeEntitiesDetectionJobResponse.getter(DescribeEntitiesDetectionJobResponse::entitiesDetectionJobProperties)).setter(DescribeEntitiesDetectionJobResponse.setter(Builder::entitiesDetectionJobProperties)).constructor(EntitiesDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitiesDetectionJobProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_DETECTION_JOB_PROPERTIES_FIELD));
    private final EntitiesDetectionJobProperties entitiesDetectionJobProperties;

    private DescribeEntitiesDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.entitiesDetectionJobProperties = builder.entitiesDetectionJobProperties;
    }

    public EntitiesDetectionJobProperties entitiesDetectionJobProperties() {
        return this.entitiesDetectionJobProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entitiesDetectionJobProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntitiesDetectionJobResponse)) {
            return false;
        }
        DescribeEntitiesDetectionJobResponse other = (DescribeEntitiesDetectionJobResponse)((Object)obj);
        return Objects.equals(this.entitiesDetectionJobProperties(), other.entitiesDetectionJobProperties());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEntitiesDetectionJobResponse").add("EntitiesDetectionJobProperties", (Object)this.entitiesDetectionJobProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntitiesDetectionJobProperties": {
                return Optional.ofNullable(clazz.cast(this.entitiesDetectionJobProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntitiesDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribeEntitiesDetectionJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private EntitiesDetectionJobProperties entitiesDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntitiesDetectionJobResponse model) {
            super(model);
            this.entitiesDetectionJobProperties(model.entitiesDetectionJobProperties);
        }

        public final EntitiesDetectionJobProperties.Builder getEntitiesDetectionJobProperties() {
            return this.entitiesDetectionJobProperties != null ? this.entitiesDetectionJobProperties.toBuilder() : null;
        }

        @Override
        public final Builder entitiesDetectionJobProperties(EntitiesDetectionJobProperties entitiesDetectionJobProperties) {
            this.entitiesDetectionJobProperties = entitiesDetectionJobProperties;
            return this;
        }

        public final void setEntitiesDetectionJobProperties(EntitiesDetectionJobProperties.BuilderImpl entitiesDetectionJobProperties) {
            this.entitiesDetectionJobProperties = entitiesDetectionJobProperties != null ? entitiesDetectionJobProperties.build() : null;
        }

        @Override
        public DescribeEntitiesDetectionJobResponse build() {
            return new DescribeEntitiesDetectionJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEntitiesDetectionJobResponse> {
        public Builder entitiesDetectionJobProperties(EntitiesDetectionJobProperties var1);

        default public Builder entitiesDetectionJobProperties(Consumer<EntitiesDetectionJobProperties.Builder> entitiesDetectionJobProperties) {
            return this.entitiesDetectionJobProperties((EntitiesDetectionJobProperties)((EntitiesDetectionJobProperties.Builder)EntitiesDetectionJobProperties.builder().applyMutation(entitiesDetectionJobProperties)).build());
        }
    }
}

