/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierOutputDataConfig;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.services.comprehend.model.Tag;
import software.amazon.awssdk.services.comprehend.model.TagListCopier;
import software.amazon.awssdk.services.comprehend.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDocumentClassifierRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, CreateDocumentClassifierRequest> {
    private static final SdkField<String> DOCUMENT_CLASSIFIER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::documentClassifierName)).setter(CreateDocumentClassifierRequest.setter(Builder::documentClassifierName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierName").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::dataAccessRoleArn)).setter(CreateDocumentClassifierRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::tags)).setter(CreateDocumentClassifierRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DocumentClassifierInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::inputDataConfig)).setter(CreateDocumentClassifierRequest.setter(Builder::inputDataConfig)).constructor(DocumentClassifierInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<DocumentClassifierOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::outputDataConfig)).setter(CreateDocumentClassifierRequest.setter(Builder::outputDataConfig)).constructor(DocumentClassifierOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::clientRequestToken)).setter(CreateDocumentClassifierRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::languageCodeAsString)).setter(CreateDocumentClassifierRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::volumeKmsKeyId)).setter(CreateDocumentClassifierRequest.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::vpcConfig)).setter(CreateDocumentClassifierRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDocumentClassifierRequest.getter(CreateDocumentClassifierRequest::modeAsString)).setter(CreateDocumentClassifierRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_CLASSIFIER_NAME_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TAGS_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LANGUAGE_CODE_FIELD, VOLUME_KMS_KEY_ID_FIELD, VPC_CONFIG_FIELD, MODE_FIELD));
    private final String documentClassifierName;
    private final String dataAccessRoleArn;
    private final List<Tag> tags;
    private final DocumentClassifierInputDataConfig inputDataConfig;
    private final DocumentClassifierOutputDataConfig outputDataConfig;
    private final String clientRequestToken;
    private final String languageCode;
    private final String volumeKmsKeyId;
    private final VpcConfig vpcConfig;
    private final String mode;

    private CreateDocumentClassifierRequest(BuilderImpl builder) {
        super(builder);
        this.documentClassifierName = builder.documentClassifierName;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.tags = builder.tags;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.languageCode = builder.languageCode;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.vpcConfig = builder.vpcConfig;
        this.mode = builder.mode;
    }

    public String documentClassifierName() {
        return this.documentClassifierName;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public DocumentClassifierInputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public DocumentClassifierOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public DocumentClassifierMode mode() {
        return DocumentClassifierMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentClassifierName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentClassifierRequest)) {
            return false;
        }
        CreateDocumentClassifierRequest other = (CreateDocumentClassifierRequest)((Object)obj);
        return Objects.equals(this.documentClassifierName(), other.documentClassifierName()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateDocumentClassifierRequest").add("DocumentClassifierName", (Object)this.documentClassifierName()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("Tags", this.tags()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("LanguageCode", (Object)this.languageCodeAsString()).add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("VpcConfig", (Object)this.vpcConfig()).add("Mode", (Object)this.modeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentClassifierName": {
                return Optional.ofNullable(clazz.cast(this.documentClassifierName()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDocumentClassifierRequest, T> g) {
        return obj -> g.apply((CreateDocumentClassifierRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String documentClassifierName;
        private String dataAccessRoleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private DocumentClassifierInputDataConfig inputDataConfig;
        private DocumentClassifierOutputDataConfig outputDataConfig;
        private String clientRequestToken;
        private String languageCode;
        private String volumeKmsKeyId;
        private VpcConfig vpcConfig;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentClassifierRequest model) {
            super(model);
            this.documentClassifierName(model.documentClassifierName);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.tags(model.tags);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.clientRequestToken(model.clientRequestToken);
            this.languageCode(model.languageCode);
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.vpcConfig(model.vpcConfig);
            this.mode(model.mode);
        }

        public final String getDocumentClassifierName() {
            return this.documentClassifierName;
        }

        @Override
        public final Builder documentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
            return this;
        }

        public final void setDocumentClassifierName(String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final DocumentClassifierInputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(DocumentClassifierInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(DocumentClassifierInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final DocumentClassifierOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(DocumentClassifierOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(DocumentClassifierOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DocumentClassifierMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentClassifierRequest build() {
            return new CreateDocumentClassifierRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDocumentClassifierRequest> {
        public Builder documentClassifierName(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder inputDataConfig(DocumentClassifierInputDataConfig var1);

        default public Builder inputDataConfig(Consumer<DocumentClassifierInputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((DocumentClassifierInputDataConfig)((DocumentClassifierInputDataConfig.Builder)DocumentClassifierInputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(DocumentClassifierOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<DocumentClassifierOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((DocumentClassifierOutputDataConfig)((DocumentClassifierOutputDataConfig.Builder)DocumentClassifierOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder volumeKmsKeyId(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder mode(String var1);

        public Builder mode(DocumentClassifierMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

