/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;
import software.amazon.awssdk.services.comprehend.model.SentimentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectSentimentResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectSentimentResponse> {
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectSentimentResponse.getter(DetectSentimentResponse::sentimentAsString)).setter(DetectSentimentResponse.setter(Builder::sentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()}).build();
    private static final SdkField<SentimentScore> SENTIMENT_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DetectSentimentResponse.getter(DetectSentimentResponse::sentimentScore)).setter(DetectSentimentResponse.setter(Builder::sentimentScore)).constructor(SentimentScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENTIMENT_FIELD, SENTIMENT_SCORE_FIELD));
    private final String sentiment;
    private final SentimentScore sentimentScore;

    private DetectSentimentResponse(BuilderImpl builder) {
        super(builder);
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    public SentimentType sentiment() {
        return SentimentType.fromValue(this.sentiment);
    }

    public String sentimentAsString() {
        return this.sentiment;
    }

    public SentimentScore sentimentScore() {
        return this.sentimentScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentScore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectSentimentResponse)) {
            return false;
        }
        DetectSentimentResponse other = (DetectSentimentResponse)((Object)obj);
        return Objects.equals(this.sentimentAsString(), other.sentimentAsString()) && Objects.equals(this.sentimentScore(), other.sentimentScore());
    }

    public String toString() {
        return ToString.builder((String)"DetectSentimentResponse").add("Sentiment", (Object)this.sentimentAsString()).add("SentimentScore", (Object)this.sentimentScore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sentiment": {
                return Optional.ofNullable(clazz.cast(this.sentimentAsString()));
            }
            case "SentimentScore": {
                return Optional.ofNullable(clazz.cast(this.sentimentScore()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectSentimentResponse, T> g) {
        return obj -> g.apply((DetectSentimentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private String sentiment;
        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectSentimentResponse model) {
            super(model);
            this.sentiment(model.sentiment);
            this.sentimentScore(model.sentimentScore);
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return this.sentimentScore != null ? this.sentimentScore.toBuilder() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        @Override
        public DetectSentimentResponse build() {
            return new DetectSentimentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectSentimentResponse> {
        public Builder sentiment(String var1);

        public Builder sentiment(SentimentType var1);

        public Builder sentimentScore(SentimentScore var1);

        default public Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return this.sentimentScore((SentimentScore)((SentimentScore.Builder)SentimentScore.builder().applyMutation(sentimentScore)).build());
        }
    }
}

