/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for filtering topic detection jobs. For more information, see .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicsDetectionJobFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicsDetectionJobFilter.Builder, TopicsDetectionJobFilter> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicsDetectionJobFilter::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicsDetectionJobFilter::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TopicsDetectionJobFilter::submitTimeBefore)).setter(setter(Builder::submitTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeBefore").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TopicsDetectionJobFilter::submitTimeAfter)).setter(setter(Builder::submitTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_STATUS_FIELD, SUBMIT_TIME_BEFORE_FIELD, SUBMIT_TIME_AFTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String jobStatus;

    private final Instant submitTimeBefore;

    private final Instant submitTimeAfter;

    private TopicsDetectionJobFilter(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Filters the list of topic detection jobs based on job status. Returns only jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Filters the list of topic detection jobs based on job status. Returns only jobs with the specified
     *         status.
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Filters the list of topic detection jobs based on job status. Returns only jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Filters the list of topic detection jobs based on job status. Returns only jobs with the specified
     *         status.
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs submitted
     * before the specified time. Jobs are returned in descending order, newest to oldest.
     * </p>
     * 
     * @return Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs
     *         submitted before the specified time. Jobs are returned in descending order, newest to oldest.
     */
    public Instant submitTimeBefore() {
        return submitTimeBefore;
    }

    /**
     * <p>
     * Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs submitted
     * after the specified time. Jobs are returned in ascending order, oldest to newest.
     * </p>
     * 
     * @return Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs
     *         submitted after the specified time. Jobs are returned in ascending order, oldest to newest.
     */
    public Instant submitTimeAfter() {
        return submitTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeAfter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicsDetectionJobFilter)) {
            return false;
        }
        TopicsDetectionJobFilter other = (TopicsDetectionJobFilter) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(submitTimeBefore(), other.submitTimeBefore())
                && Objects.equals(submitTimeAfter(), other.submitTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TopicsDetectionJobFilter").add("JobName", jobName()).add("JobStatus", jobStatusAsString())
                .add("SubmitTimeBefore", submitTimeBefore()).add("SubmitTimeAfter", submitTimeAfter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "SubmitTimeBefore":
            return Optional.ofNullable(clazz.cast(submitTimeBefore()));
        case "SubmitTimeAfter":
            return Optional.ofNullable(clazz.cast(submitTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicsDetectionJobFilter, T> g) {
        return obj -> g.apply((TopicsDetectionJobFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicsDetectionJobFilter> {
        /**
         * <p/>
         * 
         * @param jobName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Filters the list of topic detection jobs based on job status. Returns only jobs with the specified status.
         * </p>
         * 
         * @param jobStatus
         *        Filters the list of topic detection jobs based on job status. Returns only jobs with the specified
         *        status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Filters the list of topic detection jobs based on job status. Returns only jobs with the specified status.
         * </p>
         * 
         * @param jobStatus
         *        Filters the list of topic detection jobs based on job status. Returns only jobs with the specified
         *        status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs
         * submitted before the specified time. Jobs are returned in descending order, newest to oldest.
         * </p>
         * 
         * @param submitTimeBefore
         *        Filters the list of jobs based on the time that the job was submitted for processing. Only returns
         *        jobs submitted before the specified time. Jobs are returned in descending order, newest to oldest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeBefore(Instant submitTimeBefore);

        /**
         * <p>
         * Filters the list of jobs based on the time that the job was submitted for processing. Only returns jobs
         * submitted after the specified time. Jobs are returned in ascending order, oldest to newest.
         * </p>
         * 
         * @param submitTimeAfter
         *        Filters the list of jobs based on the time that the job was submitted for processing. Only returns
         *        jobs submitted after the specified time. Jobs are returned in ascending order, oldest to newest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeAfter(Instant submitTimeAfter);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobStatus;

        private Instant submitTimeBefore;

        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicsDetectionJobFilter model) {
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            submitTimeBefore(model.submitTimeBefore);
            submitTimeAfter(model.submitTimeAfter);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getSubmitTimeBefore() {
            return submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        public final Instant getSubmitTimeAfter() {
            return submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        @Override
        public TopicsDetectionJobFilter build() {
            return new TopicsDetectionJobFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
