/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input properties for training a document classifier.
 * </p>
 * <p>
 * For more information on how the input file is formatted, see <a>how-document-classification-training-data</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentClassifierInputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentClassifierInputDataConfig.Builder, DocumentClassifierInputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentClassifierInputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> LABEL_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentClassifierInputDataConfig::labelDelimiter)).setter(setter(Builder::labelDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelDelimiter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            LABEL_DELIMITER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String labelDelimiter;

    private DocumentClassifierInputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.labelDelimiter = builder.labelDelimiter;
    }

    /**
     * <p>
     * The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API endpoint that you are
     * calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
     * </p>
     * <p>
     * For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon
     * Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of
     * them as input.
     * </p>
     * 
     * @return The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API endpoint that
     *         you are calling. The URI can point to a single input file or it can provide the prefix for a collection
     *         of input files.</p>
     *         <p>
     *         For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file,
     *         Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon
     *         Comprehend uses all of them as input.
     */
    public String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter
     * between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by
     * specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the
     * delimiter you specify, the labels on that line will be combined to make a single unique label, such as
     * LABELLABELLABEL.
     * </p>
     * 
     * @return Indicates the delimiter used to separate each label for training a multi-label classifier. The default
     *         delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an
     *         allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter
     *         other than the default or the delimiter you specify, the labels on that line will be combined to make a
     *         single unique label, such as LABELLABELLABEL.
     */
    public String labelDelimiter() {
        return labelDelimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(labelDelimiter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassifierInputDataConfig)) {
            return false;
        }
        DocumentClassifierInputDataConfig other = (DocumentClassifierInputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(labelDelimiter(), other.labelDelimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DocumentClassifierInputDataConfig").add("S3Uri", s3Uri())
                .add("LabelDelimiter", labelDelimiter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "LabelDelimiter":
            return Optional.ofNullable(clazz.cast(labelDelimiter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassifierInputDataConfig, T> g) {
        return obj -> g.apply((DocumentClassifierInputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentClassifierInputDataConfig> {
        /**
         * <p>
         * The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API endpoint that you
         * are calling. The URI can point to a single input file or it can provide the prefix for a collection of input
         * files.
         * </p>
         * <p>
         * For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon
         * Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all
         * of them as input.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 URI for the input data. The S3 bucket must be in the same region as the API endpoint
         *        that you are calling. The URI can point to a single input file or it can provide the prefix for a
         *        collection of input files.</p>
         *        <p>
         *        For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file,
         *        Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon
         *        Comprehend uses all of them as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Indicates the delimiter used to separate each label for training a multi-label classifier. The default
         * delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed
         * character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than
         * the default or the delimiter you specify, the labels on that line will be combined to make a single unique
         * label, such as LABELLABELLABEL.
         * </p>
         * 
         * @param labelDelimiter
         *        Indicates the delimiter used to separate each label for training a multi-label classifier. The default
         *        delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an
         *        allowed character) by specifying it under Delimiter for labels. If the training documents use a
         *        delimiter other than the default or the delimiter you specify, the labels on that line will be
         *        combined to make a single unique label, such as LABELLABELLABEL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelDelimiter(String labelDelimiter);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String labelDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassifierInputDataConfig model) {
            s3Uri(model.s3Uri);
            labelDelimiter(model.labelDelimiter);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getLabelDelimiter() {
            return labelDelimiter;
        }

        @Override
        public final Builder labelDelimiter(String labelDelimiter) {
            this.labelDelimiter = labelDelimiter;
            return this;
        }

        public final void setLabelDelimiter(String labelDelimiter) {
            this.labelDelimiter = labelDelimiter;
        }

        @Override
        public DocumentClassifierInputDataConfig build() {
            return new DocumentClassifierInputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
