/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, UpdateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::endpointArn)).setter(UpdateEndpointRequest.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::desiredInferenceUnits)).setter(UpdateEndpointRequest.setter(Builder::desiredInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD));
    private final String endpointArn;
    private final Integer desiredInferenceUnits;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public Integer desiredInferenceUnits() {
        return this.desiredInferenceUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInferenceUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.desiredInferenceUnits(), other.desiredInferenceUnits());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEndpointRequest").add("EndpointArn", (Object)this.endpointArn()).add("DesiredInferenceUnits", (Object)this.desiredInferenceUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "DesiredInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.desiredInferenceUnits()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String endpointArn;
        private Integer desiredInferenceUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            this.endpointArn(model.endpointArn);
            this.desiredInferenceUnits(model.desiredInferenceUnits);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final Integer getDesiredInferenceUnits() {
            return this.desiredInferenceUnits;
        }

        @Override
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointRequest> {
        public Builder endpointArn(String var1);

        public Builder desiredInferenceUnits(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

