/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentClassifiersResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListDocumentClassifiersResponse> {
    private static final SdkField<List<DocumentClassifierProperties>> DOCUMENT_CLASSIFIER_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDocumentClassifiersResponse.getter(ListDocumentClassifiersResponse::documentClassifierPropertiesList)).setter(ListDocumentClassifiersResponse.setter(Builder::documentClassifierPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentClassifierProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDocumentClassifiersResponse.getter(ListDocumentClassifiersResponse::nextToken)).setter(ListDocumentClassifiersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_CLASSIFIER_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<DocumentClassifierProperties> documentClassifierPropertiesList;
    private final String nextToken;

    private ListDocumentClassifiersResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassifierPropertiesList = builder.documentClassifierPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDocumentClassifierPropertiesList() {
        return this.documentClassifierPropertiesList != null && !(this.documentClassifierPropertiesList instanceof SdkAutoConstructList);
    }

    public List<DocumentClassifierProperties> documentClassifierPropertiesList() {
        return this.documentClassifierPropertiesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentClassifierPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentClassifiersResponse)) {
            return false;
        }
        ListDocumentClassifiersResponse other = (ListDocumentClassifiersResponse)((Object)obj);
        return Objects.equals(this.documentClassifierPropertiesList(), other.documentClassifierPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDocumentClassifiersResponse").add("DocumentClassifierPropertiesList", this.documentClassifierPropertiesList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentClassifierPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.documentClassifierPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentClassifiersResponse, T> g) {
        return obj -> g.apply((ListDocumentClassifiersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DocumentClassifierProperties> documentClassifierPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentClassifiersResponse model) {
            super(model);
            this.documentClassifierPropertiesList(model.documentClassifierPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentClassifierProperties.Builder> getDocumentClassifierPropertiesList() {
            return this.documentClassifierPropertiesList != null ? (Collection)this.documentClassifierPropertiesList.stream().map(DocumentClassifierProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentClassifierPropertiesList(Collection<DocumentClassifierProperties> documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList = DocumentClassifierPropertiesListCopier.copy(documentClassifierPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierPropertiesList(DocumentClassifierProperties ... documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList(Arrays.asList(documentClassifierPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierPropertiesList(Consumer<DocumentClassifierProperties.Builder> ... documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList(Stream.of(documentClassifierPropertiesList).map(c -> (DocumentClassifierProperties)((DocumentClassifierProperties.Builder)DocumentClassifierProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentClassifierPropertiesList(Collection<DocumentClassifierProperties.BuilderImpl> documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList = DocumentClassifierPropertiesListCopier.copyFromBuilder(documentClassifierPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentClassifiersResponse build() {
            return new ListDocumentClassifiersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentClassifiersResponse> {
        public Builder documentClassifierPropertiesList(Collection<DocumentClassifierProperties> var1);

        public Builder documentClassifierPropertiesList(DocumentClassifierProperties ... var1);

        public Builder documentClassifierPropertiesList(Consumer<DocumentClassifierProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

