/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerEvaluationMetrics;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListCopier;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognizerMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognizerMetadata> {
    private static final SdkField<Integer> NUMBER_OF_TRAINED_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EntityRecognizerMetadata.getter(EntityRecognizerMetadata::numberOfTrainedDocuments)).setter(EntityRecognizerMetadata.setter(Builder::numberOfTrainedDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrainedDocuments").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_TEST_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EntityRecognizerMetadata.getter(EntityRecognizerMetadata::numberOfTestDocuments)).setter(EntityRecognizerMetadata.setter(Builder::numberOfTestDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTestDocuments").build()}).build();
    private static final SdkField<EntityRecognizerEvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EntityRecognizerMetadata.getter(EntityRecognizerMetadata::evaluationMetrics)).setter(EntityRecognizerMetadata.setter(Builder::evaluationMetrics)).constructor(EntityRecognizerEvaluationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()}).build();
    private static final SdkField<List<EntityRecognizerMetadataEntityTypesListItem>> ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EntityRecognizerMetadata.getter(EntityRecognizerMetadata::entityTypes)).setter(EntityRecognizerMetadata.setter(Builder::entityTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityRecognizerMetadataEntityTypesListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_TRAINED_DOCUMENTS_FIELD, NUMBER_OF_TEST_DOCUMENTS_FIELD, EVALUATION_METRICS_FIELD, ENTITY_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer numberOfTrainedDocuments;
    private final Integer numberOfTestDocuments;
    private final EntityRecognizerEvaluationMetrics evaluationMetrics;
    private final List<EntityRecognizerMetadataEntityTypesListItem> entityTypes;

    private EntityRecognizerMetadata(BuilderImpl builder) {
        this.numberOfTrainedDocuments = builder.numberOfTrainedDocuments;
        this.numberOfTestDocuments = builder.numberOfTestDocuments;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.entityTypes = builder.entityTypes;
    }

    public Integer numberOfTrainedDocuments() {
        return this.numberOfTrainedDocuments;
    }

    public Integer numberOfTestDocuments() {
        return this.numberOfTestDocuments;
    }

    public EntityRecognizerEvaluationMetrics evaluationMetrics() {
        return this.evaluationMetrics;
    }

    public List<EntityRecognizerMetadataEntityTypesListItem> entityTypes() {
        return this.entityTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTrainedDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTestDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerMetadata)) {
            return false;
        }
        EntityRecognizerMetadata other = (EntityRecognizerMetadata)obj;
        return Objects.equals(this.numberOfTrainedDocuments(), other.numberOfTrainedDocuments()) && Objects.equals(this.numberOfTestDocuments(), other.numberOfTestDocuments()) && Objects.equals(this.evaluationMetrics(), other.evaluationMetrics()) && Objects.equals(this.entityTypes(), other.entityTypes());
    }

    public String toString() {
        return ToString.builder((String)"EntityRecognizerMetadata").add("NumberOfTrainedDocuments", (Object)this.numberOfTrainedDocuments()).add("NumberOfTestDocuments", (Object)this.numberOfTestDocuments()).add("EvaluationMetrics", (Object)this.evaluationMetrics()).add("EntityTypes", this.entityTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfTrainedDocuments": {
                return Optional.ofNullable(clazz.cast(this.numberOfTrainedDocuments()));
            }
            case "NumberOfTestDocuments": {
                return Optional.ofNullable(clazz.cast(this.numberOfTestDocuments()));
            }
            case "EvaluationMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluationMetrics()));
            }
            case "EntityTypes": {
                return Optional.ofNullable(clazz.cast(this.entityTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerMetadata, T> g) {
        return obj -> g.apply((EntityRecognizerMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numberOfTrainedDocuments;
        private Integer numberOfTestDocuments;
        private EntityRecognizerEvaluationMetrics evaluationMetrics;
        private List<EntityRecognizerMetadataEntityTypesListItem> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerMetadata model) {
            this.numberOfTrainedDocuments(model.numberOfTrainedDocuments);
            this.numberOfTestDocuments(model.numberOfTestDocuments);
            this.evaluationMetrics(model.evaluationMetrics);
            this.entityTypes(model.entityTypes);
        }

        public final Integer getNumberOfTrainedDocuments() {
            return this.numberOfTrainedDocuments;
        }

        @Override
        public final Builder numberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
            return this;
        }

        public final void setNumberOfTrainedDocuments(Integer numberOfTrainedDocuments) {
            this.numberOfTrainedDocuments = numberOfTrainedDocuments;
        }

        public final Integer getNumberOfTestDocuments() {
            return this.numberOfTestDocuments;
        }

        @Override
        public final Builder numberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
            return this;
        }

        public final void setNumberOfTestDocuments(Integer numberOfTestDocuments) {
            this.numberOfTestDocuments = numberOfTestDocuments;
        }

        public final EntityRecognizerEvaluationMetrics.Builder getEvaluationMetrics() {
            return this.evaluationMetrics != null ? this.evaluationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder evaluationMetrics(EntityRecognizerEvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public final void setEvaluationMetrics(EntityRecognizerEvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        public final Collection<EntityRecognizerMetadataEntityTypesListItem.Builder> getEntityTypes() {
            return this.entityTypes != null ? (Collection)this.entityTypes.stream().map(EntityRecognizerMetadataEntityTypesListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityTypes(Collection<EntityRecognizerMetadataEntityTypesListItem> entityTypes) {
            this.entityTypes = EntityRecognizerMetadataEntityTypesListCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityRecognizerMetadataEntityTypesListItem ... entityTypes) {
            this.entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(Consumer<EntityRecognizerMetadataEntityTypesListItem.Builder> ... entityTypes) {
            this.entityTypes(Stream.of(entityTypes).map(c -> (EntityRecognizerMetadataEntityTypesListItem)((EntityRecognizerMetadataEntityTypesListItem.Builder)EntityRecognizerMetadataEntityTypesListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntityTypes(Collection<EntityRecognizerMetadataEntityTypesListItem.BuilderImpl> entityTypes) {
            this.entityTypes = EntityRecognizerMetadataEntityTypesListCopier.copyFromBuilder(entityTypes);
        }

        public EntityRecognizerMetadata build() {
            return new EntityRecognizerMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognizerMetadata> {
        public Builder numberOfTrainedDocuments(Integer var1);

        public Builder numberOfTestDocuments(Integer var1);

        public Builder evaluationMetrics(EntityRecognizerEvaluationMetrics var1);

        default public Builder evaluationMetrics(Consumer<EntityRecognizerEvaluationMetrics.Builder> evaluationMetrics) {
            return this.evaluationMetrics((EntityRecognizerEvaluationMetrics)((EntityRecognizerEvaluationMetrics.Builder)EntityRecognizerEvaluationMetrics.builder().applyMutation(evaluationMetrics)).build());
        }

        public Builder entityTypes(Collection<EntityRecognizerMetadataEntityTypesListItem> var1);

        public Builder entityTypes(EntityRecognizerMetadataEntityTypesListItem ... var1);

        public Builder entityTypes(Consumer<EntityRecognizerMetadataEntityTypesListItem.Builder> ... var1);
    }
}

