/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerInputDataConfig;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEntityRecognizerRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, CreateEntityRecognizerRequest> {
    private static final SdkField<String> RECOGNIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEntityRecognizerRequest.getter(CreateEntityRecognizerRequest::recognizerName)).setter(CreateEntityRecognizerRequest.setter(Builder::recognizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecognizerName").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEntityRecognizerRequest.getter(CreateEntityRecognizerRequest::dataAccessRoleArn)).setter(CreateEntityRecognizerRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<EntityRecognizerInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateEntityRecognizerRequest.getter(CreateEntityRecognizerRequest::inputDataConfig)).setter(CreateEntityRecognizerRequest.setter(Builder::inputDataConfig)).constructor(EntityRecognizerInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEntityRecognizerRequest.getter(CreateEntityRecognizerRequest::clientRequestToken)).setter(CreateEntityRecognizerRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEntityRecognizerRequest.getter(CreateEntityRecognizerRequest::languageCodeAsString)).setter(CreateEntityRecognizerRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOGNIZER_NAME_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LANGUAGE_CODE_FIELD));
    private final String recognizerName;
    private final String dataAccessRoleArn;
    private final EntityRecognizerInputDataConfig inputDataConfig;
    private final String clientRequestToken;
    private final String languageCode;

    private CreateEntityRecognizerRequest(BuilderImpl builder) {
        super(builder);
        this.recognizerName = builder.recognizerName;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.languageCode = builder.languageCode;
    }

    public String recognizerName() {
        return this.recognizerName;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public EntityRecognizerInputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recognizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEntityRecognizerRequest)) {
            return false;
        }
        CreateEntityRecognizerRequest other = (CreateEntityRecognizerRequest)((Object)obj);
        return Objects.equals(this.recognizerName(), other.recognizerName()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateEntityRecognizerRequest").add("RecognizerName", (Object)this.recognizerName()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("InputDataConfig", (Object)this.inputDataConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecognizerName": {
                return Optional.ofNullable(clazz.cast(this.recognizerName()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEntityRecognizerRequest, T> g) {
        return obj -> g.apply((CreateEntityRecognizerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String recognizerName;
        private String dataAccessRoleArn;
        private EntityRecognizerInputDataConfig inputDataConfig;
        private String clientRequestToken;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEntityRecognizerRequest model) {
            super(model);
            this.recognizerName(model.recognizerName);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.clientRequestToken(model.clientRequestToken);
            this.languageCode(model.languageCode);
        }

        public final String getRecognizerName() {
            return this.recognizerName;
        }

        @Override
        public final Builder recognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
            return this;
        }

        public final void setRecognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final EntityRecognizerInputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(EntityRecognizerInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(EntityRecognizerInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEntityRecognizerRequest build() {
            return new CreateEntityRecognizerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEntityRecognizerRequest> {
        public Builder recognizerName(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder inputDataConfig(EntityRecognizerInputDataConfig var1);

        default public Builder inputDataConfig(Consumer<EntityRecognizerInputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((EntityRecognizerInputDataConfig)((EntityRecognizerInputDataConfig.Builder)EntityRecognizerInputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

