/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;

public class ListDominantLanguageDetectionJobsIterable
implements SdkIterable<ListDominantLanguageDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListDominantLanguageDetectionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDominantLanguageDetectionJobsIterable(ComprehendClient client, ListDominantLanguageDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDominantLanguageDetectionJobsResponseFetcher();
    }

    public Iterator<ListDominantLanguageDetectionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListDominantLanguageDetectionJobsIterable resume(ListDominantLanguageDetectionJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDominantLanguageDetectionJobsIterable(this.client, (ListDominantLanguageDetectionJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDominantLanguageDetectionJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListDominantLanguageDetectionJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListDominantLanguageDetectionJobsResponseFetcher
    implements SyncPageFetcher<ListDominantLanguageDetectionJobsResponse> {
        private ListDominantLanguageDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDominantLanguageDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDominantLanguageDetectionJobsResponse nextPage(ListDominantLanguageDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDominantLanguageDetectionJobsIterable.this.client.listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsIterable.this.firstRequest);
            }
            return ListDominantLanguageDetectionJobsIterable.this.client.listDominantLanguageDetectionJobs((ListDominantLanguageDetectionJobsRequest)((Object)ListDominantLanguageDetectionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

