/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ModelStatus {
    SUBMITTED("SUBMITTED"),
    TRAINING("TRAINING"),
    DELETING("DELETING"),
    IN_ERROR("IN_ERROR"),
    TRAINED("TRAINED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ModelStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ModelStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelStatus> knownValues() {
        return Stream.of(ModelStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

