/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SentimentScoreMarshaller {
    private static final MarshallingInfo<Float> POSITIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Positive").isBinary(false).build();
    private static final MarshallingInfo<Float> NEGATIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Negative").isBinary(false).build();
    private static final MarshallingInfo<Float> NEUTRAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Neutral").isBinary(false).build();
    private static final MarshallingInfo<Float> MIXED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mixed").isBinary(false).build();
    private static final SentimentScoreMarshaller INSTANCE = new SentimentScoreMarshaller();

    private SentimentScoreMarshaller() {
    }

    public static SentimentScoreMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SentimentScore sentimentScore, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sentimentScore, (String)"sentimentScore");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sentimentScore.positive(), POSITIVE_BINDING);
            protocolMarshaller.marshall((Object)sentimentScore.negative(), NEGATIVE_BINDING);
            protocolMarshaller.marshall((Object)sentimentScore.neutral(), NEUTRAL_BINDING);
            protocolMarshaller.marshall((Object)sentimentScore.mixed(), MIXED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

