/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.Entity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EntityMarshaller {
    private static final MarshallingInfo<Float> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Score").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").isBinary(false).build();
    private static final MarshallingInfo<Integer> BEGINOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginOffset").isBinary(false).build();
    private static final MarshallingInfo<Integer> ENDOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndOffset").isBinary(false).build();
    private static final EntityMarshaller INSTANCE = new EntityMarshaller();

    private EntityMarshaller() {
    }

    public static EntityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Entity entity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)entity, (String)"entity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)entity.score(), SCORE_BINDING);
            protocolMarshaller.marshall((Object)entity.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)entity.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)entity.beginOffset(), BEGINOFFSET_BINDING);
            protocolMarshaller.marshall((Object)entity.endOffset(), ENDOFFSET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

