/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.InputDataConfig;
import software.amazon.awssdk.services.comprehend.model.OutputDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartTopicsDetectionJobRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, StartTopicsDetectionJobRequest> {
    private final InputDataConfig inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final String dataAccessRoleArn;
    private final String jobName;
    private final Integer numberOfTopics;
    private final String clientRequestToken;

    private StartTopicsDetectionJobRequest(BuilderImpl builder) {
        super(builder);
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.jobName = builder.jobName;
        this.numberOfTopics = builder.numberOfTopics;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public String jobName() {
        return this.jobName;
    }

    public Integer numberOfTopics() {
        return this.numberOfTopics;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTopics());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTopicsDetectionJobRequest)) {
            return false;
        }
        StartTopicsDetectionJobRequest other = (StartTopicsDetectionJobRequest)((Object)obj);
        return Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.numberOfTopics(), other.numberOfTopics()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"StartTopicsDetectionJobRequest").add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("JobName", (Object)this.jobName()).add("NumberOfTopics", (Object)this.numberOfTopics()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputDataConfig": {
                return Optional.of(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.of(clazz.cast(this.outputDataConfig()));
            }
            case "DataAccessRoleArn": {
                return Optional.of(clazz.cast(this.dataAccessRoleArn()));
            }
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "NumberOfTopics": {
                return Optional.of(clazz.cast(this.numberOfTopics()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private InputDataConfig inputDataConfig;
        private OutputDataConfig outputDataConfig;
        private String dataAccessRoleArn;
        private String jobName;
        private Integer numberOfTopics;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTopicsDetectionJobRequest model) {
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.jobName(model.jobName);
            this.numberOfTopics(model.numberOfTopics);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Integer getNumberOfTopics() {
            return this.numberOfTopics;
        }

        @Override
        public final Builder numberOfTopics(Integer numberOfTopics) {
            this.numberOfTopics = numberOfTopics;
            return this;
        }

        public final void setNumberOfTopics(Integer numberOfTopics) {
            this.numberOfTopics = numberOfTopics;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartTopicsDetectionJobRequest build() {
            return new StartTopicsDetectionJobRequest(this);
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    CopyableBuilder<Builder, StartTopicsDetectionJobRequest> {
        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().apply(inputDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().apply(outputDataConfig)).build());
        }

        public Builder dataAccessRoleArn(String var1);

        public Builder jobName(String var1);

        public Builder numberOfTopics(Integer var1);

        public Builder clientRequestToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

