/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.transform.DominantLanguageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DominantLanguage
implements StructuredPojo,
ToCopyableBuilder<Builder, DominantLanguage> {
    private final String languageCode;
    private final Float score;

    private DominantLanguage(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.score = builder.score;
    }

    public String languageCode() {
        return this.languageCode;
    }

    public Float score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DominantLanguage)) {
            return false;
        }
        DominantLanguage other = (DominantLanguage)obj;
        return Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.score(), other.score());
    }

    public String toString() {
        return ToString.builder((String)"DominantLanguage").add("LanguageCode", (Object)this.languageCode()).add("Score", (Object)this.score()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCode()));
            }
            case "Score": {
                return Optional.of(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DominantLanguageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(DominantLanguage model) {
            this.languageCode(model.languageCode);
            this.score(model.score);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public DominantLanguage build() {
            return new DominantLanguage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DominantLanguage> {
        public Builder languageCode(String var1);

        public Builder score(Float var1);
    }
}

