/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;

public class ListKeyPhrasesDetectionJobsPublisher
implements SdkPublisher<ListKeyPhrasesDetectionJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListKeyPhrasesDetectionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeyPhrasesDetectionJobsPublisher(ComprehendAsyncClient client, ListKeyPhrasesDetectionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeyPhrasesDetectionJobsPublisher(ComprehendAsyncClient client, ListKeyPhrasesDetectionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeyPhrasesDetectionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeyPhrasesDetectionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListKeyPhrasesDetectionJobsPublisher resume(ListKeyPhrasesDetectionJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListKeyPhrasesDetectionJobsPublisher(this.client, (ListKeyPhrasesDetectionJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListKeyPhrasesDetectionJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListKeyPhrasesDetectionJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListKeyPhrasesDetectionJobsResponseFetcher
    implements AsyncPageFetcher<ListKeyPhrasesDetectionJobsResponse> {
        private ListKeyPhrasesDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyPhrasesDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKeyPhrasesDetectionJobsResponse> nextPage(ListKeyPhrasesDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListKeyPhrasesDetectionJobsPublisher.this.client.listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsPublisher.this.firstRequest);
            }
            return ListKeyPhrasesDetectionJobsPublisher.this.client.listKeyPhrasesDetectionJobs((ListKeyPhrasesDetectionJobsRequest)((Object)ListKeyPhrasesDetectionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

