/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.MergedDatasetNameListCopier;
import software.amazon.awssdk.services.cognitosync.model.Record;
import software.amazon.awssdk.services.cognitosync.model.RecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecordsResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, ListRecordsResponse> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(ListRecordsResponse.getter(ListRecordsResponse::records)).setter(ListRecordsResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Record::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecordsResponse.getter(ListRecordsResponse::nextToken)).setter(ListRecordsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(ListRecordsResponse.getter(ListRecordsResponse::count)).setter(ListRecordsResponse.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<Long> DATASET_SYNC_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DatasetSyncCount").getter(ListRecordsResponse.getter(ListRecordsResponse::datasetSyncCount)).setter(ListRecordsResponse.setter(Builder::datasetSyncCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSyncCount").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(ListRecordsResponse.getter(ListRecordsResponse::lastModifiedBy)).setter(ListRecordsResponse.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<List<String>> MERGED_DATASET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MergedDatasetNames").getter(ListRecordsResponse.getter(ListRecordsResponse::mergedDatasetNames)).setter(ListRecordsResponse.setter(Builder::mergedDatasetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergedDatasetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DATASET_EXISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DatasetExists").getter(ListRecordsResponse.getter(ListRecordsResponse::datasetExists)).setter(ListRecordsResponse.setter(Builder::datasetExists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetExists").build()}).build();
    private static final SdkField<Boolean> DATASET_DELETED_AFTER_REQUESTED_SYNC_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DatasetDeletedAfterRequestedSyncCount").getter(ListRecordsResponse.getter(ListRecordsResponse::datasetDeletedAfterRequestedSyncCount)).setter(ListRecordsResponse.setter(Builder::datasetDeletedAfterRequestedSyncCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetDeletedAfterRequestedSyncCount").build()}).build();
    private static final SdkField<String> SYNC_SESSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncSessionToken").getter(ListRecordsResponse.getter(ListRecordsResponse::syncSessionToken)).setter(ListRecordsResponse.setter(Builder::syncSessionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSessionToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, NEXT_TOKEN_FIELD, COUNT_FIELD, DATASET_SYNC_COUNT_FIELD, LAST_MODIFIED_BY_FIELD, MERGED_DATASET_NAMES_FIELD, DATASET_EXISTS_FIELD, DATASET_DELETED_AFTER_REQUESTED_SYNC_COUNT_FIELD, SYNC_SESSION_TOKEN_FIELD));
    private final List<Record> records;
    private final String nextToken;
    private final Integer count;
    private final Long datasetSyncCount;
    private final String lastModifiedBy;
    private final List<String> mergedDatasetNames;
    private final Boolean datasetExists;
    private final Boolean datasetDeletedAfterRequestedSyncCount;
    private final String syncSessionToken;

    private ListRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextToken = builder.nextToken;
        this.count = builder.count;
        this.datasetSyncCount = builder.datasetSyncCount;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.mergedDatasetNames = builder.mergedDatasetNames;
        this.datasetExists = builder.datasetExists;
        this.datasetDeletedAfterRequestedSyncCount = builder.datasetDeletedAfterRequestedSyncCount;
        this.syncSessionToken = builder.syncSessionToken;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<Record> records() {
        return this.records;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer count() {
        return this.count;
    }

    public final Long datasetSyncCount() {
        return this.datasetSyncCount;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final boolean hasMergedDatasetNames() {
        return this.mergedDatasetNames != null && !(this.mergedDatasetNames instanceof SdkAutoConstructList);
    }

    public final List<String> mergedDatasetNames() {
        return this.mergedDatasetNames;
    }

    public final Boolean datasetExists() {
        return this.datasetExists;
    }

    public final Boolean datasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public final String syncSessionToken() {
        return this.syncSessionToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSyncCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMergedDatasetNames() ? this.mergedDatasetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetExists());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDeletedAfterRequestedSyncCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSessionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsResponse)) {
            return false;
        }
        ListRecordsResponse other = (ListRecordsResponse)((Object)obj);
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.datasetSyncCount(), other.datasetSyncCount()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && this.hasMergedDatasetNames() == other.hasMergedDatasetNames() && Objects.equals(this.mergedDatasetNames(), other.mergedDatasetNames()) && Objects.equals(this.datasetExists(), other.datasetExists()) && Objects.equals(this.datasetDeletedAfterRequestedSyncCount(), other.datasetDeletedAfterRequestedSyncCount()) && Objects.equals(this.syncSessionToken(), other.syncSessionToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecordsResponse").add("Records", this.hasRecords() ? this.records() : null).add("NextToken", (Object)this.nextToken()).add("Count", (Object)this.count()).add("DatasetSyncCount", (Object)this.datasetSyncCount()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("MergedDatasetNames", this.hasMergedDatasetNames() ? this.mergedDatasetNames() : null).add("DatasetExists", (Object)this.datasetExists()).add("DatasetDeletedAfterRequestedSyncCount", (Object)this.datasetDeletedAfterRequestedSyncCount()).add("SyncSessionToken", (Object)this.syncSessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "DatasetSyncCount": {
                return Optional.ofNullable(clazz.cast(this.datasetSyncCount()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "MergedDatasetNames": {
                return Optional.ofNullable(clazz.cast(this.mergedDatasetNames()));
            }
            case "DatasetExists": {
                return Optional.ofNullable(clazz.cast(this.datasetExists()));
            }
            case "DatasetDeletedAfterRequestedSyncCount": {
                return Optional.ofNullable(clazz.cast(this.datasetDeletedAfterRequestedSyncCount()));
            }
            case "SyncSessionToken": {
                return Optional.ofNullable(clazz.cast(this.syncSessionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecordsResponse, T> g) {
        return obj -> g.apply((ListRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer count;
        private Long datasetSyncCount;
        private String lastModifiedBy;
        private List<String> mergedDatasetNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean datasetExists;
        private Boolean datasetDeletedAfterRequestedSyncCount;
        private String syncSessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordsResponse model) {
            super(model);
            this.records(model.records);
            this.nextToken(model.nextToken);
            this.count(model.count);
            this.datasetSyncCount(model.datasetSyncCount);
            this.lastModifiedBy(model.lastModifiedBy);
            this.mergedDatasetNames(model.mergedDatasetNames);
            this.datasetExists(model.datasetExists);
            this.datasetDeletedAfterRequestedSyncCount(model.datasetDeletedAfterRequestedSyncCount);
            this.syncSessionToken(model.syncSessionToken);
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Long getDatasetSyncCount() {
            return this.datasetSyncCount;
        }

        public final void setDatasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
        }

        @Override
        public final Builder datasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Collection<String> getMergedDatasetNames() {
            if (this.mergedDatasetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mergedDatasetNames;
        }

        public final void setMergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
        }

        @Override
        public final Builder mergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergedDatasetNames(String ... mergedDatasetNames) {
            this.mergedDatasetNames(Arrays.asList(mergedDatasetNames));
            return this;
        }

        public final Boolean getDatasetExists() {
            return this.datasetExists;
        }

        public final void setDatasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
        }

        @Override
        public final Builder datasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
            return this;
        }

        public final Boolean getDatasetDeletedAfterRequestedSyncCount() {
            return this.datasetDeletedAfterRequestedSyncCount;
        }

        public final void setDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
        }

        @Override
        public final Builder datasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
            return this;
        }

        public final String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        @Override
        public ListRecordsResponse build() {
            return new ListRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder count(Integer var1);

        public Builder datasetSyncCount(Long var1);

        public Builder lastModifiedBy(String var1);

        public Builder mergedDatasetNames(Collection<String> var1);

        public Builder mergedDatasetNames(String ... var1);

        public Builder datasetExists(Boolean var1);

        public Builder datasetDeletedAfterRequestedSyncCount(Boolean var1);

        public Builder syncSessionToken(String var1);
    }
}

