/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Record
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Record> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(Record.getter(Record::key)).setter(Record.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(Record.getter(Record::value)).setter(Record.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Long> SYNC_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SyncCount").getter(Record.getter(Record::syncCount)).setter(Record.setter(Builder::syncCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCount").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(Record.getter(Record::lastModifiedDate)).setter(Record.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(Record.getter(Record::lastModifiedBy)).setter(Record.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> DEVICE_LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeviceLastModifiedDate").getter(Record.getter(Record::deviceLastModifiedDate)).setter(Record.setter(Builder::deviceLastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceLastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD, SYNC_COUNT_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_BY_FIELD, DEVICE_LAST_MODIFIED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String value;
    private final Long syncCount;
    private final Instant lastModifiedDate;
    private final String lastModifiedBy;
    private final Instant deviceLastModifiedDate;

    private Record(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.syncCount = builder.syncCount;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
    }

    public final String key() {
        return this.key;
    }

    public final String value() {
        return this.value;
    }

    public final Long syncCount() {
        return this.syncCount;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant deviceLastModifiedDate() {
        return this.deviceLastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceLastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.syncCount(), other.syncCount()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.deviceLastModifiedDate(), other.deviceLastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"Record").add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("SyncCount", (Object)this.syncCount()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("DeviceLastModifiedDate", (Object)this.deviceLastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "SyncCount": {
                return Optional.ofNullable(clazz.cast(this.syncCount()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "DeviceLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.deviceLastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Long syncCount;
        private Instant lastModifiedDate;
        private String lastModifiedBy;
        private Instant deviceLastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.key(model.key);
            this.value(model.value);
            this.syncCount(model.syncCount);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedBy(model.lastModifiedBy);
            this.deviceLastModifiedDate(model.deviceLastModifiedDate);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Long getSyncCount() {
            return this.syncCount;
        }

        @Override
        public final Builder syncCount(Long syncCount) {
            this.syncCount = syncCount;
            return this;
        }

        public final void setSyncCount(Long syncCount) {
            this.syncCount = syncCount;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Instant getDeviceLastModifiedDate() {
            return this.deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        public Record build() {
            return new Record(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Record> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder syncCount(Long var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder deviceLastModifiedDate(Instant var1);
    }
}

