/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncRequest;
import software.amazon.awssdk.services.cognitosync.model.RecordPatch;
import software.amazon.awssdk.services.cognitosync.model.RecordPatchListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecordsRequest
extends CognitoSyncRequest
implements ToCopyableBuilder<Builder, UpdateRecordsRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(UpdateRecordsRequest.getter(UpdateRecordsRequest::identityPoolId)).setter(UpdateRecordsRequest.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(UpdateRecordsRequest.getter(UpdateRecordsRequest::identityId)).setter(UpdateRecordsRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityId").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(UpdateRecordsRequest.getter(UpdateRecordsRequest::datasetName)).setter(UpdateRecordsRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(UpdateRecordsRequest.getter(UpdateRecordsRequest::deviceId)).setter(UpdateRecordsRequest.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<List<RecordPatch>> RECORD_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordPatches").getter(UpdateRecordsRequest.getter(UpdateRecordsRequest::recordPatches)).setter(UpdateRecordsRequest.setter(Builder::recordPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordPatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordPatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SYNC_SESSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncSessionToken").getter(UpdateRecordsRequest.getter(UpdateRecordsRequest::syncSessionToken)).setter(UpdateRecordsRequest.setter(Builder::syncSessionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSessionToken").build()}).build();
    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientContext").getter(UpdateRecordsRequest.getter(UpdateRecordsRequest::clientContext)).setter(UpdateRecordsRequest.setter(Builder::clientContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Client-Context").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, IDENTITY_ID_FIELD, DATASET_NAME_FIELD, DEVICE_ID_FIELD, RECORD_PATCHES_FIELD, SYNC_SESSION_TOKEN_FIELD, CLIENT_CONTEXT_FIELD));
    private final String identityPoolId;
    private final String identityId;
    private final String datasetName;
    private final String deviceId;
    private final List<RecordPatch> recordPatches;
    private final String syncSessionToken;
    private final String clientContext;

    private UpdateRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
        this.deviceId = builder.deviceId;
        this.recordPatches = builder.recordPatches;
        this.syncSessionToken = builder.syncSessionToken;
        this.clientContext = builder.clientContext;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final boolean hasRecordPatches() {
        return this.recordPatches != null && !(this.recordPatches instanceof SdkAutoConstructList);
    }

    public final List<RecordPatch> recordPatches() {
        return this.recordPatches;
    }

    public final String syncSessionToken() {
        return this.syncSessionToken;
    }

    public final String clientContext() {
        return this.clientContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordPatches() ? this.recordPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecordsRequest)) {
            return false;
        }
        UpdateRecordsRequest other = (UpdateRecordsRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.deviceId(), other.deviceId()) && this.hasRecordPatches() == other.hasRecordPatches() && Objects.equals(this.recordPatches(), other.recordPatches()) && Objects.equals(this.syncSessionToken(), other.syncSessionToken()) && Objects.equals(this.clientContext(), other.clientContext());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecordsRequest").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityId", (Object)this.identityId()).add("DatasetName", (Object)this.datasetName()).add("DeviceId", (Object)this.deviceId()).add("RecordPatches", this.hasRecordPatches() ? this.recordPatches() : null).add("SyncSessionToken", (Object)this.syncSessionToken()).add("ClientContext", (Object)this.clientContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "RecordPatches": {
                return Optional.ofNullable(clazz.cast(this.recordPatches()));
            }
            case "SyncSessionToken": {
                return Optional.ofNullable(clazz.cast(this.syncSessionToken()));
            }
            case "ClientContext": {
                return Optional.ofNullable(clazz.cast(this.clientContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecordsRequest, T> g) {
        return obj -> g.apply((UpdateRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoSyncRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String datasetName;
        private String deviceId;
        private List<RecordPatch> recordPatches = DefaultSdkAutoConstructList.getInstance();
        private String syncSessionToken;
        private String clientContext;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecordsRequest model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.datasetName(model.datasetName);
            this.deviceId(model.deviceId);
            this.recordPatches(model.recordPatches);
            this.syncSessionToken(model.syncSessionToken);
            this.clientContext(model.clientContext);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final Collection<RecordPatch.Builder> getRecordPatches() {
            if (this.recordPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordPatches != null ? (Collection)this.recordPatches.stream().map(RecordPatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordPatches(Collection<RecordPatch> recordPatches) {
            this.recordPatches = RecordPatchListCopier.copy(recordPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordPatches(RecordPatch ... recordPatches) {
            this.recordPatches(Arrays.asList(recordPatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordPatches(Consumer<RecordPatch.Builder> ... recordPatches) {
            this.recordPatches(Stream.of(recordPatches).map(c -> (RecordPatch)((RecordPatch.Builder)RecordPatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecordPatches(Collection<RecordPatch.BuilderImpl> recordPatches) {
            this.recordPatches = RecordPatchListCopier.copyFromBuilder(recordPatches);
        }

        public final String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecordsRequest build() {
            return new UpdateRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecordsRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder datasetName(String var1);

        public Builder deviceId(String var1);

        public Builder recordPatches(Collection<RecordPatch> var1);

        public Builder recordPatches(RecordPatch ... var1);

        public Builder recordPatches(Consumer<RecordPatch.Builder> ... var1);

        public Builder syncSessionToken(String var1);

        public Builder clientContext(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

