/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Usage information for the identity pool.
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityPoolUsage implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityPoolUsage.Builder, IdentityPoolUsage> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IdentityPoolUsage::identityPoolId)).setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<Long> SYNC_SESSIONS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(IdentityPoolUsage::syncSessionsCount)).setter(setter(Builder::syncSessionsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSessionsCount").build()).build();

    private static final SdkField<Long> DATA_STORAGE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(IdentityPoolUsage::dataStorage)).setter(setter(Builder::dataStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorage").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(IdentityPoolUsage::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            SYNC_SESSIONS_COUNT_FIELD, DATA_STORAGE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identityPoolId;

    private final Long syncSessionsCount;

    private final Long dataStorage;

    private final Instant lastModifiedDate;

    private IdentityPoolUsage(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.syncSessionsCount = builder.syncSessionsCount;
        this.dataStorage = builder.dataStorage;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * Number of sync sessions for the identity pool.
     * 
     * @return Number of sync sessions for the identity pool.
     */
    public Long syncSessionsCount() {
        return syncSessionsCount;
    }

    /**
     * Data storage information for the identity pool.
     * 
     * @return Data storage information for the identity pool.
     */
    public Long dataStorage() {
        return dataStorage;
    }

    /**
     * Date on which the identity pool was last modified.
     * 
     * @return Date on which the identity pool was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(syncSessionsCount());
        hashCode = 31 * hashCode + Objects.hashCode(dataStorage());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityPoolUsage)) {
            return false;
        }
        IdentityPoolUsage other = (IdentityPoolUsage) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(syncSessionsCount(), other.syncSessionsCount())
                && Objects.equals(dataStorage(), other.dataStorage())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IdentityPoolUsage").add("IdentityPoolId", identityPoolId())
                .add("SyncSessionsCount", syncSessionsCount()).add("DataStorage", dataStorage())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "SyncSessionsCount":
            return Optional.ofNullable(clazz.cast(syncSessionsCount()));
        case "DataStorage":
            return Optional.ofNullable(clazz.cast(dataStorage()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityPoolUsage, T> g) {
        return obj -> g.apply((IdentityPoolUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityPoolUsage> {
        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityPoolId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * Number of sync sessions for the identity pool.
         * 
         * @param syncSessionsCount
         *        Number of sync sessions for the identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSessionsCount(Long syncSessionsCount);

        /**
         * Data storage information for the identity pool.
         * 
         * @param dataStorage
         *        Data storage information for the identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorage(Long dataStorage);

        /**
         * Date on which the identity pool was last modified.
         * 
         * @param lastModifiedDate
         *        Date on which the identity pool was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String identityPoolId;

        private Long syncSessionsCount;

        private Long dataStorage;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityPoolUsage model) {
            identityPoolId(model.identityPoolId);
            syncSessionsCount(model.syncSessionsCount);
            dataStorage(model.dataStorage);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Long getSyncSessionsCount() {
            return syncSessionsCount;
        }

        @Override
        public final Builder syncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
            return this;
        }

        public final void setSyncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
        }

        public final Long getDataStorage() {
            return dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public IdentityPoolUsage build() {
            return new IdentityPoolUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
