/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.transform.IdentityUsageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdentityUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, IdentityUsage> {
    private final String identityId;
    private final String identityPoolId;
    private final Instant lastModifiedDate;
    private final Integer datasetCount;
    private final Long dataStorage;

    private IdentityUsage(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.datasetCount = builder.datasetCount;
        this.dataStorage = builder.dataStorage;
    }

    public String identityId() {
        return this.identityId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Integer datasetCount() {
        return this.datasetCount;
    }

    public Long dataStorage() {
        return this.dataStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityUsage)) {
            return false;
        }
        IdentityUsage other = (IdentityUsage)obj;
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.datasetCount(), other.datasetCount()) && Objects.equals(this.dataStorage(), other.dataStorage());
    }

    public String toString() {
        return ToString.builder((String)"IdentityUsage").add("IdentityId", (Object)this.identityId()).add("IdentityPoolId", (Object)this.identityPoolId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("DatasetCount", (Object)this.datasetCount()).add("DataStorage", (Object)this.dataStorage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "DatasetCount": {
                return Optional.of(clazz.cast(this.datasetCount()));
            }
            case "DataStorage": {
                return Optional.of(clazz.cast(this.dataStorage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityId;
        private String identityPoolId;
        private Instant lastModifiedDate;
        private Integer datasetCount;
        private Long dataStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityUsage model) {
            this.identityId(model.identityId);
            this.identityPoolId(model.identityPoolId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.datasetCount(model.datasetCount);
            this.dataStorage(model.dataStorage);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getDatasetCount() {
            return this.datasetCount;
        }

        @Override
        public final Builder datasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
            return this;
        }

        public final void setDatasetCount(Integer datasetCount) {
            this.datasetCount = datasetCount;
        }

        public final Long getDataStorage() {
            return this.dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        public IdentityUsage build() {
            return new IdentityUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityUsage> {
        public Builder identityId(String var1);

        public Builder identityPoolId(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder datasetCount(Integer var1);

        public Builder dataStorage(Long var1);
    }
}

