/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cognitosync.model.Platform;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterDeviceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterDeviceRequest> {
    private final String identityPoolId;
    private final String identityId;
    private final String platform;
    private final String token;

    private RegisterDeviceRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.platform = builder.platform;
        this.token = builder.token;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformString() {
        return this.platform;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.platformString() == null ? 0 : this.platformString().hashCode());
        hashCode = 31 * hashCode + (this.token() == null ? 0 : this.token().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDeviceRequest)) {
            return false;
        }
        RegisterDeviceRequest other = (RegisterDeviceRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.platformString() == null ^ this.platformString() == null) {
            return false;
        }
        if (other.platformString() != null && !other.platformString().equals(this.platformString())) {
            return false;
        }
        if (other.token() == null ^ this.token() == null) {
            return false;
        }
        return other.token() == null || other.token().equals(this.token());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.platformString() != null) {
            sb.append("Platform: ").append(this.platformString()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platformString()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String platform;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDeviceRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.platform(model.platform);
            this.token(model.token);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public RegisterDeviceRequest build() {
            return new RegisterDeviceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterDeviceRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder token(String var1);
    }
}

