/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitosync.model.RecordPatch;

public class RecordPatchUnmarshaller
implements Unmarshaller<RecordPatch, JsonUnmarshallerContext> {
    private static final RecordPatchUnmarshaller INSTANCE = new RecordPatchUnmarshaller();

    public RecordPatch unmarshall(JsonUnmarshallerContext context) throws Exception {
        RecordPatch.Builder recordPatchBuilder = RecordPatch.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Op", targetDepth)) {
                    context.nextToken();
                    recordPatchBuilder.op((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Key", targetDepth)) {
                    context.nextToken();
                    recordPatchBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    recordPatchBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SyncCount", targetDepth)) {
                    context.nextToken();
                    recordPatchBuilder.syncCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeviceLastModifiedDate", targetDepth)) {
                    context.nextToken();
                    recordPatchBuilder.deviceLastModifiedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RecordPatch)recordPatchBuilder.build();
    }

    public static RecordPatchUnmarshaller getInstance() {
        return INSTANCE;
    }
}

