/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cognitosync.model.CognitoStreams;
import software.amazon.awssdk.services.cognitosync.model.PushSync;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetIdentityPoolConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetIdentityPoolConfigurationRequest> {
    private final String identityPoolId;
    private final PushSync pushSync;
    private final CognitoStreams cognitoStreams;

    private SetIdentityPoolConfigurationRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.pushSync = builder.pushSync;
        this.cognitoStreams = builder.cognitoStreams;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public PushSync pushSync() {
        return this.pushSync;
    }

    public CognitoStreams cognitoStreams() {
        return this.cognitoStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.pushSync() == null ? 0 : this.pushSync().hashCode());
        hashCode = 31 * hashCode + (this.cognitoStreams() == null ? 0 : this.cognitoStreams().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityPoolConfigurationRequest)) {
            return false;
        }
        SetIdentityPoolConfigurationRequest other = (SetIdentityPoolConfigurationRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.pushSync() == null ^ this.pushSync() == null) {
            return false;
        }
        if (other.pushSync() != null && !other.pushSync().equals(this.pushSync())) {
            return false;
        }
        if (other.cognitoStreams() == null ^ this.cognitoStreams() == null) {
            return false;
        }
        return other.cognitoStreams() == null || other.cognitoStreams().equals(this.cognitoStreams());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.pushSync() != null) {
            sb.append("PushSync: ").append(this.pushSync()).append(",");
        }
        if (this.cognitoStreams() != null) {
            sb.append("CognitoStreams: ").append(this.cognitoStreams()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private PushSync pushSync;
        private CognitoStreams cognitoStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityPoolConfigurationRequest model) {
            this.setIdentityPoolId(model.identityPoolId);
            this.setPushSync(model.pushSync);
            this.setCognitoStreams(model.cognitoStreams);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final PushSync getPushSync() {
            return this.pushSync;
        }

        @Override
        public final Builder pushSync(PushSync pushSync) {
            this.pushSync = pushSync;
            return this;
        }

        public final void setPushSync(PushSync pushSync) {
            this.pushSync = pushSync;
        }

        public final CognitoStreams getCognitoStreams() {
            return this.cognitoStreams;
        }

        @Override
        public final Builder cognitoStreams(CognitoStreams cognitoStreams) {
            this.cognitoStreams = cognitoStreams;
            return this;
        }

        public final void setCognitoStreams(CognitoStreams cognitoStreams) {
            this.cognitoStreams = cognitoStreams;
        }

        public SetIdentityPoolConfigurationRequest build() {
            return new SetIdentityPoolConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetIdentityPoolConfigurationRequest> {
        public Builder identityPoolId(String var1);

        public Builder pushSync(PushSync var1);

        public Builder cognitoStreams(CognitoStreams var1);
    }
}

