/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage;
import software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentityPoolUsageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListIdentityPoolUsageResponse> {
    private final List<IdentityPoolUsage> identityPoolUsages;
    private final Integer maxResults;
    private final Integer count;
    private final String nextToken;

    private ListIdentityPoolUsageResponse(BuilderImpl builder) {
        this.identityPoolUsages = builder.identityPoolUsages;
        this.maxResults = builder.maxResults;
        this.count = builder.count;
        this.nextToken = builder.nextToken;
    }

    public List<IdentityPoolUsage> identityPoolUsages() {
        return this.identityPoolUsages;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer count() {
        return this.count;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolUsages() == null ? 0 : this.identityPoolUsages().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolUsageResponse)) {
            return false;
        }
        ListIdentityPoolUsageResponse other = (ListIdentityPoolUsageResponse)((Object)obj);
        if (other.identityPoolUsages() == null ^ this.identityPoolUsages() == null) {
            return false;
        }
        if (other.identityPoolUsages() != null && !other.identityPoolUsages().equals(this.identityPoolUsages())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPoolUsages() != null) {
            sb.append("IdentityPoolUsages: ").append(this.identityPoolUsages()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<IdentityPoolUsage> identityPoolUsages;
        private Integer maxResults;
        private Integer count;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolUsageResponse model) {
            this.setIdentityPoolUsages(model.identityPoolUsages);
            this.setMaxResults(model.maxResults);
            this.setCount(model.count);
            this.setNextToken(model.nextToken);
        }

        public final Collection<IdentityPoolUsage> getIdentityPoolUsages() {
            return this.identityPoolUsages;
        }

        @Override
        public final Builder identityPoolUsages(Collection<IdentityPoolUsage> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copy(identityPoolUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPoolUsages(IdentityPoolUsage ... identityPoolUsages) {
            this.identityPoolUsages(Arrays.asList(identityPoolUsages));
            return this;
        }

        public final void setIdentityPoolUsages(Collection<IdentityPoolUsage> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copy(identityPoolUsages);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListIdentityPoolUsageResponse build() {
            return new ListIdentityPoolUsageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIdentityPoolUsageResponse> {
        public Builder identityPoolUsages(Collection<IdentityPoolUsage> var1);

        public Builder identityPoolUsages(IdentityPoolUsage ... var1);

        public Builder maxResults(Integer var1);

        public Builder count(Integer var1);

        public Builder nextToken(String var1);
    }
}

