/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Target
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Target> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(Target.getter(Target::targetType)).setter(Target.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> TARGET_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAddress").getter(Target.getter(Target::targetAddress)).setter(Target.setter(Builder::targetAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD, TARGET_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TargetType", TARGET_TYPE_FIELD);
            this.put("TargetAddress", TARGET_ADDRESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String targetType;
    private final String targetAddress;

    private Target(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.targetAddress = builder.targetAddress;
    }

    public final String targetType() {
        return this.targetType;
    }

    public final String targetAddress() {
        return this.targetAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)obj;
        return Objects.equals(this.targetType(), other.targetType()) && Objects.equals(this.targetAddress(), other.targetAddress());
    }

    public final String toString() {
        return ToString.builder((String)"Target").add("TargetType", (Object)this.targetType()).add("TargetAddress", (Object)(this.targetAddress() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
            case "TargetAddress": {
                return Optional.ofNullable(clazz.cast(this.targetAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetType;
        private String targetAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            this.targetType(model.targetType);
            this.targetAddress(model.targetAddress);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final String getTargetAddress() {
            return this.targetAddress;
        }

        public final void setTargetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
        }

        @Override
        public final Builder targetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public Target build() {
            return new Target(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Target> {
        public Builder targetType(String var1);

        public Builder targetAddress(String var1);
    }
}

