/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsAsyncClient;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsAsyncClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarnotifications.DefaultCodestarNotificationsAsyncClient;
import software.amazon.awssdk.services.codestarnotifications.DefaultCodestarNotificationsBaseClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.endpoints.CodestarNotificationsEndpointProvider;

@SdkInternalApi
final class DefaultCodestarNotificationsAsyncClientBuilder
extends DefaultCodestarNotificationsBaseClientBuilder<CodestarNotificationsAsyncClientBuilder, CodestarNotificationsAsyncClient>
implements CodestarNotificationsAsyncClientBuilder {
    DefaultCodestarNotificationsAsyncClientBuilder() {
    }

    @Override
    public DefaultCodestarNotificationsAsyncClientBuilder endpointProvider(CodestarNotificationsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodestarNotificationsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodestarNotificationsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodestarNotificationsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodestarNotificationsAsyncClient client = new DefaultCodestarNotificationsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodestarNotificationsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodestarNotificationsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

