/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsAsyncClient;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse;
import software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary;

public class ListNotificationRulesPublisher
implements SdkPublisher<ListNotificationRulesResponse> {
    private final CodestarNotificationsAsyncClient client;
    private final ListNotificationRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotificationRulesPublisher(CodestarNotificationsAsyncClient client, ListNotificationRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotificationRulesPublisher(CodestarNotificationsAsyncClient client, ListNotificationRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotificationRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotificationRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotificationRuleSummary> notificationRules() {
        Function<ListNotificationRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationRules() != null) {
                return response.notificationRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotificationRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotificationRulesResponseFetcher
    implements AsyncPageFetcher<ListNotificationRulesResponse> {
        private ListNotificationRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotificationRulesResponse> nextPage(ListNotificationRulesResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationRulesPublisher.this.client.listNotificationRules(ListNotificationRulesPublisher.this.firstRequest);
            }
            return ListNotificationRulesPublisher.this.client.listNotificationRules((ListNotificationRulesRequest)((Object)ListNotificationRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

