/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the targets specified for a notification rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetSummary implements SdkPojo, Serializable, ToCopyableBuilder<TargetSummary.Builder, TargetSummary> {
    private static final SdkField<String> TARGET_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAddress").getter(getter(TargetSummary::targetAddress)).setter(setter(Builder::targetAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAddress").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetType").getter(getter(TargetSummary::targetType)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetStatus").getter(getter(TargetSummary::targetStatusAsString)).setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ADDRESS_FIELD,
            TARGET_TYPE_FIELD, TARGET_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetAddress;

    private final String targetType;

    private final String targetStatus;

    private TargetSummary(BuilderImpl builder) {
        this.targetAddress = builder.targetAddress;
        this.targetType = builder.targetType;
        this.targetStatus = builder.targetStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SNS topic.
     */
    public final String targetAddress() {
        return targetAddress;
    }

    /**
     * <p>
     * The type of the target (for example, SNS).
     * </p>
     * 
     * @return The type of the target (for example, SNS).
     */
    public final String targetType() {
        return targetType;
    }

    /**
     * <p>
     * The status of the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link TargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The status of the target.
     * @see TargetStatus
     */
    public final TargetStatus targetStatus() {
        return TargetStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The status of the target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link TargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The status of the target.
     * @see TargetStatus
     */
    public final String targetStatusAsString() {
        return targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetAddress());
        hashCode = 31 * hashCode + Objects.hashCode(targetType());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetSummary)) {
            return false;
        }
        TargetSummary other = (TargetSummary) obj;
        return Objects.equals(targetAddress(), other.targetAddress()) && Objects.equals(targetType(), other.targetType())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetSummary")
                .add("TargetAddress", targetAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TargetType", targetType()).add("TargetStatus", targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetAddress":
            return Optional.ofNullable(clazz.cast(targetAddress()));
        case "TargetType":
            return Optional.ofNullable(clazz.cast(targetType()));
        case "TargetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetSummary, T> g) {
        return obj -> g.apply((TargetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SNS topic.
         * </p>
         * 
         * @param targetAddress
         *        The Amazon Resource Name (ARN) of the SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAddress(String targetAddress);

        /**
         * <p>
         * The type of the target (for example, SNS).
         * </p>
         * 
         * @param targetType
         *        The type of the target (for example, SNS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The status of the target.
         * </p>
         * 
         * @param targetStatus
         *        The status of the target.
         * @see TargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The status of the target.
         * </p>
         * 
         * @param targetStatus
         *        The status of the target.
         * @see TargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStatus
         */
        Builder targetStatus(TargetStatus targetStatus);
    }

    static final class BuilderImpl implements Builder {
        private String targetAddress;

        private String targetType;

        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetSummary model) {
            targetAddress(model.targetAddress);
            targetType(model.targetType);
            targetStatus(model.targetStatus);
        }

        public final String getTargetAddress() {
            return targetAddress;
        }

        @Override
        public final Builder targetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public final void setTargetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
        }

        public final String getTargetType() {
            return targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(TargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public TargetSummary build() {
            return new TargetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
