/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsClient;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse;
import software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary;

public class ListNotificationRulesIterable
implements SdkIterable<ListNotificationRulesResponse> {
    private final CodestarNotificationsClient client;
    private final ListNotificationRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotificationRulesIterable(CodestarNotificationsClient client, ListNotificationRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNotificationRulesResponseFetcher();
    }

    public Iterator<ListNotificationRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotificationRuleSummary> notificationRules() {
        Function<ListNotificationRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationRules() != null) {
                return response.notificationRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotificationRulesResponseFetcher
    implements SyncPageFetcher<ListNotificationRulesResponse> {
        private ListNotificationRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotificationRulesResponse nextPage(ListNotificationRulesResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationRulesIterable.this.client.listNotificationRules(ListNotificationRulesIterable.this.firstRequest);
            }
            return ListNotificationRulesIterable.this.client.listNotificationRules((ListNotificationRulesRequest)((Object)ListNotificationRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

