/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codestarnotifications.model.CodestarNotificationsRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DetailType;
import software.amazon.awssdk.services.codestarnotifications.model.EventTypeIdsCopier;
import software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleStatus;
import software.amazon.awssdk.services.codestarnotifications.model.Target;
import software.amazon.awssdk.services.codestarnotifications.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotificationRuleRequest
extends CodestarNotificationsRequest
implements ToCopyableBuilder<Builder, UpdateNotificationRuleRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotificationRuleRequest.getter(UpdateNotificationRuleRequest::arn)).setter(UpdateNotificationRuleRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotificationRuleRequest.getter(UpdateNotificationRuleRequest::name)).setter(UpdateNotificationRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotificationRuleRequest.getter(UpdateNotificationRuleRequest::statusAsString)).setter(UpdateNotificationRuleRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> EVENT_TYPE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateNotificationRuleRequest.getter(UpdateNotificationRuleRequest::eventTypeIds)).setter(UpdateNotificationRuleRequest.setter(Builder::eventTypeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateNotificationRuleRequest.getter(UpdateNotificationRuleRequest::targets)).setter(UpdateNotificationRuleRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateNotificationRuleRequest.getter(UpdateNotificationRuleRequest::detailTypeAsString)).setter(UpdateNotificationRuleRequest.setter(Builder::detailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, STATUS_FIELD, EVENT_TYPE_IDS_FIELD, TARGETS_FIELD, DETAIL_TYPE_FIELD));
    private final String arn;
    private final String name;
    private final String status;
    private final List<String> eventTypeIds;
    private final List<Target> targets;
    private final String detailType;

    private UpdateNotificationRuleRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.eventTypeIds = builder.eventTypeIds;
        this.targets = builder.targets;
        this.detailType = builder.detailType;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public NotificationRuleStatus status() {
        return NotificationRuleStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<String> eventTypeIds() {
        return this.eventTypeIds;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public DetailType detailType() {
        return DetailType.fromValue(this.detailType);
    }

    public String detailTypeAsString() {
        return this.detailType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRuleRequest)) {
            return false;
        }
        UpdateNotificationRuleRequest other = (UpdateNotificationRuleRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.eventTypeIds(), other.eventTypeIds()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.detailTypeAsString(), other.detailTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateNotificationRuleRequest").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("EventTypeIds", this.eventTypeIds()).add("Targets", this.targets()).add("DetailType", (Object)this.detailTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EventTypeIds": {
                return Optional.ofNullable(clazz.cast(this.eventTypeIds()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "DetailType": {
                return Optional.ofNullable(clazz.cast(this.detailTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotificationRuleRequest, T> g) {
        return obj -> g.apply((UpdateNotificationRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodestarNotificationsRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String status;
        private List<String> eventTypeIds = DefaultSdkAutoConstructList.getInstance();
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String detailType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRuleRequest model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.eventTypeIds(model.eventTypeIds);
            this.targets(model.targets);
            this.detailType(model.detailType);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getEventTypeIds() {
            return this.eventTypeIds;
        }

        @Override
        public final Builder eventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeIds(String ... eventTypeIds) {
            this.eventTypeIds(Arrays.asList(eventTypeIds));
            return this;
        }

        public final void setEventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getDetailTypeAsString() {
            return this.detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        @Override
        public final Builder detailType(DetailType detailType) {
            this.detailType(detailType == null ? null : detailType.toString());
            return this;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationRuleRequest build() {
            return new UpdateNotificationRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodestarNotificationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNotificationRuleRequest> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(NotificationRuleStatus var1);

        public Builder eventTypeIds(Collection<String> var1);

        public Builder eventTypeIds(String ... var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder detailType(String var1);

        public Builder detailType(DetailType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

