/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsClient;
import software.amazon.awssdk.services.codestarconnections.internal.UserAgentUtils;
import software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListRepositoryLinksResponse;

public class ListRepositoryLinksIterable
implements SdkIterable<ListRepositoryLinksResponse> {
    private final CodeStarConnectionsClient client;
    private final ListRepositoryLinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRepositoryLinksIterable(CodeStarConnectionsClient client, ListRepositoryLinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRepositoryLinksResponseFetcher();
    }

    public Iterator<ListRepositoryLinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRepositoryLinksResponseFetcher
    implements SyncPageFetcher<ListRepositoryLinksResponse> {
        private ListRepositoryLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoryLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRepositoryLinksResponse nextPage(ListRepositoryLinksResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoryLinksIterable.this.client.listRepositoryLinks(ListRepositoryLinksIterable.this.firstRequest);
            }
            return ListRepositoryLinksIterable.this.client.listRepositoryLinks((ListRepositoryLinksRequest)((Object)ListRepositoryLinksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

