/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsClient;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsClientBuilder;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsBaseClientBuilder;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsClient;
import software.amazon.awssdk.services.codestarconnections.endpoints.CodeStarConnectionsEndpointProvider;

@SdkInternalApi
final class DefaultCodeStarConnectionsClientBuilder
extends DefaultCodeStarConnectionsBaseClientBuilder<CodeStarConnectionsClientBuilder, CodeStarConnectionsClient>
implements CodeStarConnectionsClientBuilder {
    DefaultCodeStarConnectionsClientBuilder() {
    }

    @Override
    public DefaultCodeStarConnectionsClientBuilder endpointProvider(CodeStarConnectionsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeStarConnectionsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeStarConnectionsClientBuilder.validateClientOptions(clientConfiguration);
        CodeStarConnectionsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeStarConnectionsClient client = new DefaultCodeStarConnectionsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeStarConnectionsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeStarConnectionsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

