/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsClient;
import software.amazon.awssdk.services.codestarconnections.model.ListHostsRequest;
import software.amazon.awssdk.services.codestarconnections.model.ListHostsResponse;

public class ListHostsIterable
implements SdkIterable<ListHostsResponse> {
    private final CodeStarConnectionsClient client;
    private final ListHostsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHostsIterable(CodeStarConnectionsClient client, ListHostsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHostsResponseFetcher();
    }

    public Iterator<ListHostsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListHostsResponseFetcher
    implements SyncPageFetcher<ListHostsResponse> {
        private ListHostsResponseFetcher() {
        }

        public boolean hasNextPage(ListHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHostsResponse nextPage(ListHostsResponse previousPage) {
            if (previousPage == null) {
                return ListHostsIterable.this.client.listHosts(ListHostsIterable.this.firstRequest);
            }
            return ListHostsIterable.this.client.listHosts((ListHostsRequest)((Object)ListHostsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

