/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestar.model.CodeStarResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProjectResponse
extends CodeStarResponse
implements ToCopyableBuilder<Builder, DeleteProjectResponse> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackId").getter(DeleteProjectResponse.getter(DeleteProjectResponse::stackId)).setter(DeleteProjectResponse.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackId").build()}).build();
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(DeleteProjectResponse.getter(DeleteProjectResponse::projectArn)).setter(DeleteProjectResponse.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, PROJECT_ARN_FIELD));
    private final String stackId;
    private final String projectArn;

    private DeleteProjectResponse(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.projectArn = builder.projectArn;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectResponse)) {
            return false;
        }
        DeleteProjectResponse other = (DeleteProjectResponse)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.projectArn(), other.projectArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteProjectResponse").add("StackId", (Object)this.stackId()).add("ProjectArn", (Object)this.projectArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectResponse, T> g) {
        return obj -> g.apply((DeleteProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarResponse.BuilderImpl
    implements Builder {
        private String stackId;
        private String projectArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectResponse model) {
            super(model);
            this.stackId(model.stackId);
            this.projectArn(model.projectArn);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public DeleteProjectResponse build() {
            return new DeleteProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProjectResponse> {
        public Builder stackId(String var1);

        public Builder projectArn(String var1);
    }
}

