/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectRequest extends CodeStarRequest implements
        ToCopyableBuilder<CreateProjectRequest.Builder, CreateProjectRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProjectRequest::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<List<Code>> SOURCE_CODE_FIELD = SdkField
            .<List<Code>> builder(MarshallingType.LIST)
            .getter(getter(CreateProjectRequest::sourceCode))
            .setter(setter(Builder::sourceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Code> builder(MarshallingType.SDK_POJO)
                                            .constructor(Code::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Toolchain> TOOLCHAIN_FIELD = SdkField.<Toolchain> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProjectRequest::toolchain)).setter(setter(Builder::toolchain)).constructor(Toolchain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolchain").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, SOURCE_CODE_FIELD, TOOLCHAIN_FIELD, TAGS_FIELD));

    private final String name;

    private final String id;

    private final String description;

    private final String clientRequestToken;

    private final List<Code> sourceCode;

    private final Toolchain toolchain;

    private final Map<String, String> tags;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.id = builder.id;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.sourceCode = builder.sourceCode;
        this.toolchain = builder.toolchain;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The display name for the project to be created in AWS CodeStar.
     * </p>
     * 
     * @return The display name for the project to be created in AWS CodeStar.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the project to be created in AWS CodeStar.
     * </p>
     * 
     * @return The ID of the project to be created in AWS CodeStar.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The description of the project, if any.
     * </p>
     * 
     * @return The description of the project, if any.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A user- or system-generated token that identifies the entity that requested project creation. This token can be
     * used to repeat the request.
     * </p>
     * 
     * @return A user- or system-generated token that identifies the entity that requested project creation. This token
     *         can be used to repeat the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the SourceCode property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSourceCode() {
        return sourceCode != null && !(sourceCode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Code objects submitted with the project request. If this parameter is specified, the request must
     * also include the toolchain parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceCode()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the Code objects submitted with the project request. If this parameter is specified, the
     *         request must also include the toolchain parameter.
     */
    public List<Code> sourceCode() {
        return sourceCode;
    }

    /**
     * <p>
     * The name of the toolchain template file submitted with the project request. If this parameter is specified, the
     * request must also include the sourceCode parameter.
     * </p>
     * 
     * @return The name of the toolchain template file submitted with the project request. If this parameter is
     *         specified, the request must also include the sourceCode parameter.
     */
    public Toolchain toolchain() {
        return toolchain;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags created for the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags created for the project.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCode());
        hashCode = 31 * hashCode + Objects.hashCode(toolchain());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(description(), other.description())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(sourceCode(), other.sourceCode()) && Objects.equals(toolchain(), other.toolchain())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProjectRequest").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Id", id()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken()).add("SourceCode", sourceCode()).add("Toolchain", toolchain())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "sourceCode":
            return Optional.ofNullable(clazz.cast(sourceCode()));
        case "toolchain":
            return Optional.ofNullable(clazz.cast(toolchain()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectRequest> {
        /**
         * <p>
         * The display name for the project to be created in AWS CodeStar.
         * </p>
         * 
         * @param name
         *        The display name for the project to be created in AWS CodeStar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the project to be created in AWS CodeStar.
         * </p>
         * 
         * @param id
         *        The ID of the project to be created in AWS CodeStar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description of the project, if any.
         * </p>
         * 
         * @param description
         *        The description of the project, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A user- or system-generated token that identifies the entity that requested project creation. This token can
         * be used to repeat the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A user- or system-generated token that identifies the entity that requested project creation. This
         *        token can be used to repeat the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A list of the Code objects submitted with the project request. If this parameter is specified, the request
         * must also include the toolchain parameter.
         * </p>
         * 
         * @param sourceCode
         *        A list of the Code objects submitted with the project request. If this parameter is specified, the
         *        request must also include the toolchain parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCode(Collection<Code> sourceCode);

        /**
         * <p>
         * A list of the Code objects submitted with the project request. If this parameter is specified, the request
         * must also include the toolchain parameter.
         * </p>
         * 
         * @param sourceCode
         *        A list of the Code objects submitted with the project request. If this parameter is specified, the
         *        request must also include the toolchain parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCode(Code... sourceCode);

        /**
         * <p>
         * A list of the Code objects submitted with the project request. If this parameter is specified, the request
         * must also include the toolchain parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Code>.Builder} avoiding the need to create
         * one manually via {@link List<Code>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Code>.Builder#build()} is called immediately and its result
         * is passed to {@link #sourceCode(List<Code>)}.
         * 
         * @param sourceCode
         *        a consumer that will call methods on {@link List<Code>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCode(List<Code>)
         */
        Builder sourceCode(Consumer<Code.Builder>... sourceCode);

        /**
         * <p>
         * The name of the toolchain template file submitted with the project request. If this parameter is specified,
         * the request must also include the sourceCode parameter.
         * </p>
         * 
         * @param toolchain
         *        The name of the toolchain template file submitted with the project request. If this parameter is
         *        specified, the request must also include the sourceCode parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolchain(Toolchain toolchain);

        /**
         * <p>
         * The name of the toolchain template file submitted with the project request. If this parameter is specified,
         * the request must also include the sourceCode parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link Toolchain.Builder} avoiding the need to create
         * one manually via {@link Toolchain#builder()}.
         *
         * When the {@link Consumer} completes, {@link Toolchain.Builder#build()} is called immediately and its result
         * is passed to {@link #toolchain(Toolchain)}.
         * 
         * @param toolchain
         *        a consumer that will call methods on {@link Toolchain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolchain(Toolchain)
         */
        default Builder toolchain(Consumer<Toolchain.Builder> toolchain) {
            return toolchain(Toolchain.builder().applyMutation(toolchain).build());
        }

        /**
         * <p>
         * The tags created for the project.
         * </p>
         * 
         * @param tags
         *        The tags created for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarRequest.BuilderImpl implements Builder {
        private String name;

        private String id;

        private String description;

        private String clientRequestToken;

        private List<Code> sourceCode = DefaultSdkAutoConstructList.getInstance();

        private Toolchain toolchain;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            name(model.name);
            id(model.id);
            description(model.description);
            clientRequestToken(model.clientRequestToken);
            sourceCode(model.sourceCode);
            toolchain(model.toolchain);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Code.Builder> getSourceCode() {
            return sourceCode != null ? sourceCode.stream().map(Code::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceCode(Collection<Code> sourceCode) {
            this.sourceCode = SourceCodeCopier.copy(sourceCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCode(Code... sourceCode) {
            sourceCode(Arrays.asList(sourceCode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCode(Consumer<Code.Builder>... sourceCode) {
            sourceCode(Stream.of(sourceCode).map(c -> Code.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceCode(Collection<Code.BuilderImpl> sourceCode) {
            this.sourceCode = SourceCodeCopier.copyFromBuilder(sourceCode);
        }

        public final Toolchain.Builder getToolchain() {
            return toolchain != null ? toolchain.toBuilder() : null;
        }

        @Override
        public final Builder toolchain(Toolchain toolchain) {
            this.toolchain = toolchain;
            return this;
        }

        public final void setToolchain(Toolchain.BuilderImpl toolchain) {
            this.toolchain = toolchain != null ? toolchain.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
