/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.Job;
import software.amazon.awssdk.services.codepipeline.model.JobListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForJobsResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, PollForJobsResponse> {
    private static final SdkField<List<Job>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PollForJobsResponse.getter(PollForJobsResponse::jobs)).setter(PollForJobsResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Job::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD));
    private final List<Job> jobs;

    private PollForJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    public List<Job> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForJobsResponse)) {
            return false;
        }
        PollForJobsResponse other = (PollForJobsResponse)((Object)obj);
        return Objects.equals(this.jobs(), other.jobs());
    }

    public String toString() {
        return ToString.builder((String)"PollForJobsResponse").add("Jobs", this.jobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForJobsResponse, T> g) {
        return obj -> g.apply((PollForJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<Job> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PollForJobsResponse model) {
            super(model);
            this.jobs(model.jobs);
        }

        public final Collection<Job.Builder> getJobs() {
            return this.jobs != null ? (Collection)this.jobs.stream().map(Job::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<Job.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (Job)((Job.Builder)Job.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = JobListCopier.copyFromBuilder(jobs);
        }

        @Override
        public PollForJobsResponse build() {
            return new PollForJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForJobsResponse> {
        public Builder jobs(Collection<Job> var1);

        public Builder jobs(Job ... var1);

        public Builder jobs(Consumer<Job.Builder> ... var1);
    }
}

