/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionOwner;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActionTypesRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, ListActionTypesRequest> {
    private static final SdkField<String> ACTION_OWNER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListActionTypesRequest.getter(ListActionTypesRequest::actionOwnerFilterAsString)).setter(ListActionTypesRequest.setter(Builder::actionOwnerFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionOwnerFilter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListActionTypesRequest.getter(ListActionTypesRequest::nextToken)).setter(ListActionTypesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_OWNER_FILTER_FIELD, NEXT_TOKEN_FIELD));
    private final String actionOwnerFilter;
    private final String nextToken;

    private ListActionTypesRequest(BuilderImpl builder) {
        super(builder);
        this.actionOwnerFilter = builder.actionOwnerFilter;
        this.nextToken = builder.nextToken;
    }

    public ActionOwner actionOwnerFilter() {
        return ActionOwner.fromValue(this.actionOwnerFilter);
    }

    public String actionOwnerFilterAsString() {
        return this.actionOwnerFilter;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOwnerFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionTypesRequest)) {
            return false;
        }
        ListActionTypesRequest other = (ListActionTypesRequest)((Object)obj);
        return Objects.equals(this.actionOwnerFilterAsString(), other.actionOwnerFilterAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListActionTypesRequest").add("ActionOwnerFilter", (Object)this.actionOwnerFilterAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionOwnerFilter": {
                return Optional.ofNullable(clazz.cast(this.actionOwnerFilterAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListActionTypesRequest, T> g) {
        return obj -> g.apply((ListActionTypesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String actionOwnerFilter;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionTypesRequest model) {
            super(model);
            this.actionOwnerFilter(model.actionOwnerFilter);
            this.nextToken(model.nextToken);
        }

        public final String getActionOwnerFilterAsString() {
            return this.actionOwnerFilter;
        }

        @Override
        public final Builder actionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
            return this;
        }

        @Override
        public final Builder actionOwnerFilter(ActionOwner actionOwnerFilter) {
            this.actionOwnerFilter(actionOwnerFilter.toString());
            return this;
        }

        public final void setActionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListActionTypesRequest build() {
            return new ListActionTypesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActionTypesRequest> {
        public Builder actionOwnerFilter(String var1);

        public Builder actionOwnerFilter(ActionOwner var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

