/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.WebhookAuthConfiguration;
import software.amazon.awssdk.services.codepipeline.model.WebhookAuthenticationType;
import software.amazon.awssdk.services.codepipeline.model.WebhookFilterRule;
import software.amazon.awssdk.services.codepipeline.model.WebhookFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebhookDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebhookDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookDefinition.getter(WebhookDefinition::name)).setter(WebhookDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TARGET_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookDefinition.getter(WebhookDefinition::targetPipeline)).setter(WebhookDefinition.setter(Builder::targetPipeline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPipeline").build()}).build();
    private static final SdkField<String> TARGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookDefinition.getter(WebhookDefinition::targetAction)).setter(WebhookDefinition.setter(Builder::targetAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAction").build()}).build();
    private static final SdkField<List<WebhookFilterRule>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(WebhookDefinition.getter(WebhookDefinition::filters)).setter(WebhookDefinition.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebhookFilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookDefinition.getter(WebhookDefinition::authenticationAsString)).setter(WebhookDefinition.setter(Builder::authentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<WebhookAuthConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WebhookDefinition.getter(WebhookDefinition::authenticationConfiguration)).setter(WebhookDefinition.setter(Builder::authenticationConfiguration)).constructor(WebhookAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TARGET_PIPELINE_FIELD, TARGET_ACTION_FIELD, FILTERS_FIELD, AUTHENTICATION_FIELD, AUTHENTICATION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String targetPipeline;
    private final String targetAction;
    private final List<WebhookFilterRule> filters;
    private final String authentication;
    private final WebhookAuthConfiguration authenticationConfiguration;

    private WebhookDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.targetPipeline = builder.targetPipeline;
        this.targetAction = builder.targetAction;
        this.filters = builder.filters;
        this.authentication = builder.authentication;
        this.authenticationConfiguration = builder.authenticationConfiguration;
    }

    public String name() {
        return this.name;
    }

    public String targetPipeline() {
        return this.targetPipeline;
    }

    public String targetAction() {
        return this.targetAction;
    }

    public List<WebhookFilterRule> filters() {
        return this.filters;
    }

    public WebhookAuthenticationType authentication() {
        return WebhookAuthenticationType.fromValue(this.authentication);
    }

    public String authenticationAsString() {
        return this.authentication;
    }

    public WebhookAuthConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookDefinition)) {
            return false;
        }
        WebhookDefinition other = (WebhookDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.targetPipeline(), other.targetPipeline()) && Objects.equals(this.targetAction(), other.targetAction()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.authenticationAsString(), other.authenticationAsString()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"WebhookDefinition").add("Name", (Object)this.name()).add("TargetPipeline", (Object)this.targetPipeline()).add("TargetAction", (Object)this.targetAction()).add("Filters", this.filters()).add("Authentication", (Object)this.authenticationAsString()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "targetPipeline": {
                return Optional.ofNullable(clazz.cast(this.targetPipeline()));
            }
            case "targetAction": {
                return Optional.ofNullable(clazz.cast(this.targetAction()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "authentication": {
                return Optional.ofNullable(clazz.cast(this.authenticationAsString()));
            }
            case "authenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebhookDefinition, T> g) {
        return obj -> g.apply((WebhookDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String targetPipeline;
        private String targetAction;
        private List<WebhookFilterRule> filters = DefaultSdkAutoConstructList.getInstance();
        private String authentication;
        private WebhookAuthConfiguration authenticationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookDefinition model) {
            this.name(model.name);
            this.targetPipeline(model.targetPipeline);
            this.targetAction(model.targetAction);
            this.filters(model.filters);
            this.authentication(model.authentication);
            this.authenticationConfiguration(model.authenticationConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTargetPipeline() {
            return this.targetPipeline;
        }

        @Override
        public final Builder targetPipeline(String targetPipeline) {
            this.targetPipeline = targetPipeline;
            return this;
        }

        public final void setTargetPipeline(String targetPipeline) {
            this.targetPipeline = targetPipeline;
        }

        public final String getTargetAction() {
            return this.targetAction;
        }

        @Override
        public final Builder targetAction(String targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        public final void setTargetAction(String targetAction) {
            this.targetAction = targetAction;
        }

        public final Collection<WebhookFilterRule.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(WebhookFilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<WebhookFilterRule> filters) {
            this.filters = WebhookFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(WebhookFilterRule ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<WebhookFilterRule.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (WebhookFilterRule)((WebhookFilterRule.Builder)WebhookFilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<WebhookFilterRule.BuilderImpl> filters) {
            this.filters = WebhookFiltersCopier.copyFromBuilder(filters);
        }

        public final String getAuthenticationAsString() {
            return this.authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        @Override
        public final Builder authentication(WebhookAuthenticationType authentication) {
            this.authentication(authentication == null ? null : authentication.toString());
            return this;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        public final WebhookAuthConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder authenticationConfiguration(WebhookAuthConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final void setAuthenticationConfiguration(WebhookAuthConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        public WebhookDefinition build() {
            return new WebhookDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebhookDefinition> {
        public Builder name(String var1);

        public Builder targetPipeline(String var1);

        public Builder targetAction(String var1);

        public Builder filters(Collection<WebhookFilterRule> var1);

        public Builder filters(WebhookFilterRule ... var1);

        public Builder filters(Consumer<WebhookFilterRule.Builder> ... var1);

        public Builder authentication(String var1);

        public Builder authentication(WebhookAuthenticationType var1);

        public Builder authenticationConfiguration(WebhookAuthConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<WebhookAuthConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((WebhookAuthConfiguration)((WebhookAuthConfiguration.Builder)WebhookAuthConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }
    }
}

