/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.model.ListWebhookItem;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse;

public class ListWebhooksIterable
implements SdkIterable<ListWebhooksResponse> {
    private final CodePipelineClient client;
    private final ListWebhooksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWebhooksIterable(CodePipelineClient client, ListWebhooksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWebhooksResponseFetcher();
    }

    public Iterator<ListWebhooksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListWebhookItem> webhooks() {
        Function<ListWebhooksResponse, Iterator> getIterator = response -> {
            if (response != null && response.webhooks() != null) {
                return response.webhooks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWebhooksResponseFetcher
    implements SyncPageFetcher<ListWebhooksResponse> {
        private ListWebhooksResponseFetcher() {
        }

        public boolean hasNextPage(ListWebhooksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWebhooksResponse nextPage(ListWebhooksResponse previousPage) {
            if (previousPage == null) {
                return ListWebhooksIterable.this.client.listWebhooks(ListWebhooksIterable.this.firstRequest);
            }
            return ListWebhooksIterable.this.client.listWebhooks((ListWebhooksRequest)((Object)ListWebhooksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

