/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineServiceClientConfiguration;
import software.amazon.awssdk.services.codepipeline.internal.CodePipelineServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ActionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ApprovalAlreadyCompletedException;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineException;
import software.amazon.awssdk.services.codepipeline.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codepipeline.model.ConcurrentPipelineExecutionsLimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ConditionNotOverridableException;
import software.amazon.awssdk.services.codepipeline.model.ConflictException;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.DuplicatedStopRequestException;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.InvalidActionDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidApprovalTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidArnException;
import software.amazon.awssdk.services.codepipeline.model.InvalidBlockerDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidClientTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobStateException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNonceException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStageDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStructureException;
import software.amazon.awssdk.services.codepipeline.model.InvalidTagsException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookAuthenticationParametersException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookFilterPatternException;
import software.amazon.awssdk.services.codepipeline.model.JobNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.LimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListRuleTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListRuleTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse;
import software.amazon.awssdk.services.codepipeline.model.NotLatestPipelineExecutionException;
import software.amazon.awssdk.services.codepipeline.model.OutputVariablesSizeExceededException;
import software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionRequest;
import software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionResponse;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotStoppableException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionOutdatedException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNameInUseException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineVersionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.RequestFailedException;
import software.amazon.awssdk.services.codepipeline.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse;
import software.amazon.awssdk.services.codepipeline.model.StageNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.StageNotRetryableException;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.TagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.TagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.TooManyTagsException;
import software.amazon.awssdk.services.codepipeline.model.UnableToRollbackStageException;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ValidationException;
import software.amazon.awssdk.services.codepipeline.model.WebhookNotFoundException;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeThirdPartyJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreateCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeregisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DisableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.EnableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineStateRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetThirdPartyJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionTypesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListDeployActionExecutionTargetsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListRuleExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListRuleTypesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListWebhooksRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.OverrideStageConditionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForThirdPartyJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutActionRevisionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutApprovalResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RegisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RetryStageExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RollbackStageRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StopPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdateActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCodePipelineAsyncClient
implements CodePipelineAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodePipelineAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodePipelineAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CodePipeline#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AcknowledgeJobResponse> acknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acknowledgeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, acknowledgeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcknowledgeJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AcknowledgeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)acknowledgeJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$acknowledgeJob$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$acknowledgeJob$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AcknowledgeThirdPartyJobResponse> acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acknowledgeThirdPartyJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, acknowledgeThirdPartyJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcknowledgeThirdPartyJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeThirdPartyJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeThirdPartyJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AcknowledgeThirdPartyJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)acknowledgeThirdPartyJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$acknowledgeThirdPartyJob$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$acknowledgeThirdPartyJob$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomActionTypeResponse> createCustomActionType(CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomActionType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomActionTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomActionTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$createCustomActionType$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$createCustomActionType$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, createPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$createPipeline$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$createPipeline$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomActionTypeResponse> deleteCustomActionType(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomActionType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomActionTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomActionTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$deleteCustomActionType$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$deleteCustomActionType$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, deletePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$deletePipeline$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$deletePipeline$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWebhookResponse> deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, deleteWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebhook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebhookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteWebhookRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$deleteWebhook$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$deleteWebhook$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterWebhookWithThirdPartyResponse> deregisterWebhookWithThirdParty(DeregisterWebhookWithThirdPartyRequest deregisterWebhookWithThirdPartyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterWebhookWithThirdPartyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterWebhookWithThirdPartyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterWebhookWithThirdParty");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterWebhookWithThirdPartyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterWebhookWithThirdParty").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterWebhookWithThirdPartyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$deregisterWebhookWithThirdParty$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$deregisterWebhookWithThirdParty$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableStageTransitionResponse> disableStageTransition(DisableStageTransitionRequest disableStageTransitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableStageTransitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, disableStageTransitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableStageTransition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableStageTransitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableStageTransition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableStageTransitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$disableStageTransition$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$disableStageTransition$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableStageTransitionResponse> enableStageTransition(EnableStageTransitionRequest enableStageTransitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableStageTransitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, enableStageTransitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableStageTransition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableStageTransitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableStageTransition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableStageTransitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$enableStageTransition$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$enableStageTransition$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetActionTypeResponse> getActionType(GetActionTypeRequest getActionTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, getActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActionType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActionTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getActionTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$getActionType$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$getActionType$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobDetailsResponse> getJobDetails(GetJobDetailsRequest getJobDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, getJobDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$getJobDetails$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$getJobDetails$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPipelineResponse> getPipeline(GetPipelineRequest getPipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, getPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$getPipeline$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$getPipeline$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPipelineExecutionResponse> getPipelineExecution(GetPipelineExecutionRequest getPipelineExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, getPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPipelineExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$getPipelineExecution$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$getPipelineExecution$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPipelineStateResponse> getPipelineState(GetPipelineStateRequest getPipelineStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, getPipelineStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPipelineStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPipelineStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$getPipelineState$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$getPipelineState$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetThirdPartyJobDetailsResponse> getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getThirdPartyJobDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, getThirdPartyJobDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetThirdPartyJobDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetThirdPartyJobDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetThirdPartyJobDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetThirdPartyJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getThirdPartyJobDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$getThirdPartyJobDetails$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$getThirdPartyJobDetails$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListActionExecutionsResponse> listActionExecutions(ListActionExecutionsRequest listActionExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActionExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listActionExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActionExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListActionExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listActionExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listActionExecutions$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listActionExecutions$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListActionTypesResponse> listActionTypes(ListActionTypesRequest listActionTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActionTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listActionTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActionTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListActionTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listActionTypesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listActionTypes$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listActionTypes$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDeployActionExecutionTargetsResponse> listDeployActionExecutionTargets(ListDeployActionExecutionTargetsRequest listDeployActionExecutionTargetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDeployActionExecutionTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listDeployActionExecutionTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDeployActionExecutionTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeployActionExecutionTargetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeployActionExecutionTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDeployActionExecutionTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDeployActionExecutionTargetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listDeployActionExecutionTargets$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listDeployActionExecutionTargets$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPipelineExecutionsResponse> listPipelineExecutions(ListPipelineExecutionsRequest listPipelineExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelineExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listPipelineExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelineExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPipelineExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPipelineExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listPipelineExecutions$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listPipelineExecutions$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPipelinesResponse> listPipelines(ListPipelinesRequest listPipelinesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listPipelinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPipelinesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listPipelines$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listPipelines$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRuleExecutionsResponse> listRuleExecutions(ListRuleExecutionsRequest listRuleExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRuleExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listRuleExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRuleExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRuleExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listRuleExecutions$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listRuleExecutions$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRuleTypesResponse> listRuleTypes(ListRuleTypesRequest listRuleTypesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRuleTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listRuleTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRuleTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRuleTypesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listRuleTypes$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listRuleTypes$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listTagsForResource$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listTagsForResource$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWebhooksResponse> listWebhooks(ListWebhooksRequest listWebhooksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWebhooksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, listWebhooksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWebhooks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebhooksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebhooks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWebhooksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listWebhooksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$listWebhooks$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$listWebhooks$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<OverrideStageConditionResponse> overrideStageCondition(OverrideStageConditionRequest overrideStageConditionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)overrideStageConditionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, overrideStageConditionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OverrideStageCondition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, OverrideStageConditionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("OverrideStageCondition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new OverrideStageConditionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)overrideStageConditionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$overrideStageCondition$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$overrideStageCondition$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PollForJobsResponse> pollForJobs(PollForJobsRequest pollForJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, pollForJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PollForJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)pollForJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$pollForJobs$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$pollForJobs$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PollForThirdPartyJobsResponse> pollForThirdPartyJobs(PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForThirdPartyJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, pollForThirdPartyJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForThirdPartyJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForThirdPartyJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForThirdPartyJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PollForThirdPartyJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)pollForThirdPartyJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$pollForThirdPartyJobs$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$pollForThirdPartyJobs$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutActionRevisionResponse> putActionRevision(PutActionRevisionRequest putActionRevisionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putActionRevisionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, putActionRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutActionRevision");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutActionRevisionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutActionRevision").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutActionRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putActionRevisionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$putActionRevision$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$putActionRevision$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutApprovalResultResponse> putApprovalResult(PutApprovalResultRequest putApprovalResultRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putApprovalResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, putApprovalResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutApprovalResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApprovalResultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApprovalResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutApprovalResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putApprovalResultRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$putApprovalResult$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$putApprovalResult$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutJobFailureResultResponse> putJobFailureResult(PutJobFailureResultRequest putJobFailureResultRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putJobFailureResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, putJobFailureResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobFailureResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobFailureResultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobFailureResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putJobFailureResultRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$putJobFailureResult$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$putJobFailureResult$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutJobSuccessResultResponse> putJobSuccessResult(PutJobSuccessResultRequest putJobSuccessResultRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putJobSuccessResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, putJobSuccessResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobSuccessResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobSuccessResultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobSuccessResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putJobSuccessResultRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$putJobSuccessResult$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$putJobSuccessResult$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutThirdPartyJobFailureResultResponse> putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putThirdPartyJobFailureResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, putThirdPartyJobFailureResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutThirdPartyJobFailureResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobFailureResultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobFailureResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutThirdPartyJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putThirdPartyJobFailureResultRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$putThirdPartyJobFailureResult$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$putThirdPartyJobFailureResult$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutThirdPartyJobSuccessResultResponse> putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putThirdPartyJobSuccessResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, putThirdPartyJobSuccessResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutThirdPartyJobSuccessResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobSuccessResultResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobSuccessResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutThirdPartyJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putThirdPartyJobSuccessResultRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$putThirdPartyJobSuccessResult$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$putThirdPartyJobSuccessResult$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutWebhookResponse> putWebhook(PutWebhookRequest putWebhookRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, putWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutWebhook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutWebhookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putWebhookRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$putWebhook$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$putWebhook$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterWebhookWithThirdPartyResponse> registerWebhookWithThirdParty(RegisterWebhookWithThirdPartyRequest registerWebhookWithThirdPartyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerWebhookWithThirdPartyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, registerWebhookWithThirdPartyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterWebhookWithThirdParty");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWebhookWithThirdPartyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWebhookWithThirdParty").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerWebhookWithThirdPartyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$registerWebhookWithThirdParty$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$registerWebhookWithThirdParty$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RetryStageExecutionResponse> retryStageExecution(RetryStageExecutionRequest retryStageExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retryStageExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, retryStageExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetryStageExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryStageExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryStageExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RetryStageExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)retryStageExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$retryStageExecution$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$retryStageExecution$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RollbackStageResponse> rollbackStage(RollbackStageRequest rollbackStageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rollbackStageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, rollbackStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RollbackStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RollbackStageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RollbackStage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RollbackStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rollbackStageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$rollbackStage$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$rollbackStage$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartPipelineExecutionResponse> startPipelineExecution(StartPipelineExecutionRequest startPipelineExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, startPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPipelineExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipelineExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startPipelineExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$startPipelineExecution$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$startPipelineExecution$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopPipelineExecutionResponse> stopPipelineExecution(StopPipelineExecutionRequest stopPipelineExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, stopPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPipelineExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPipelineExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopPipelineExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$stopPipelineExecution$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$stopPipelineExecution$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$tagResource$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$tagResource$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$untagResource$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$untagResource$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateActionTypeResponse> updateActionType(UpdateActionTypeRequest updateActionTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, updateActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateActionType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateActionTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateActionTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$updateActionType$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$updateActionType$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineAsyncClient.resolveMetricPublishers(clientConfiguration, updatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidWebhookAuthenticationParametersException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                    }
                    case "InvalidActionDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "PipelineExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                    }
                    case "PipelineNameInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "InvalidJobException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ActionTypeNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                    }
                    case "StageNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                    }
                    case "DuplicatedStopRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                    }
                    case "ActionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                    }
                    case "InvalidStageDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "NotLatestPipelineExecutionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                    case "InvalidClientTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                    }
                    case "InvalidJobStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                    }
                    case "PipelineVersionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                    }
                    case "InvalidWebhookFilterPatternException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                    }
                    case "OutputVariablesSizeExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                    }
                    case "WebhookNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                    }
                    case "InvalidApprovalTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                    }
                    case "ApprovalAlreadyCompletedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                    }
                    case "ConditionNotOverridableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                    }
                    case "PipelineNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                    }
                    case "PipelineExecutionOutdatedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                    }
                    case "StageNotRetryableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ConcurrentPipelineExecutionsLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                    }
                    case "InvalidStructureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                    }
                    case "InvalidBlockerDeclarationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                    }
                    case "UnableToRollbackStageException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                    }
                    case "ActionExecutionNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                    }
                    case "InvalidNonceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                    }
                    case "JobNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                    }
                    case "PipelineExecutionNotStoppableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodePipelineAsyncClient.lambda$updatePipeline$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineAsyncClient.lambda$updatePipeline$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CodePipelineServiceClientConfiguration serviceClientConfiguration() {
        return new CodePipelineServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "codepipeline";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodePipelineException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CodePipelineServiceClientConfigurationBuilder serviceConfigBuilder = new CodePipelineServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updatePipeline$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePipeline$174(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateActionType$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateActionType$170(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateActionTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$166(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$162(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopPipelineExecution$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPipelineExecution$158(List metricPublishers, MetricCollector apiCallMetricCollector, StopPipelineExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startPipelineExecution$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPipelineExecution$154(List metricPublishers, MetricCollector apiCallMetricCollector, StartPipelineExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rollbackStage$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rollbackStage$150(List metricPublishers, MetricCollector apiCallMetricCollector, RollbackStageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$retryStageExecution$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retryStageExecution$146(List metricPublishers, MetricCollector apiCallMetricCollector, RetryStageExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerWebhookWithThirdParty$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerWebhookWithThirdParty$142(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterWebhookWithThirdPartyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putWebhook$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putWebhook$138(List metricPublishers, MetricCollector apiCallMetricCollector, PutWebhookResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putThirdPartyJobSuccessResult$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putThirdPartyJobSuccessResult$134(List metricPublishers, MetricCollector apiCallMetricCollector, PutThirdPartyJobSuccessResultResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putThirdPartyJobFailureResult$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putThirdPartyJobFailureResult$130(List metricPublishers, MetricCollector apiCallMetricCollector, PutThirdPartyJobFailureResultResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putJobSuccessResult$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobSuccessResult$126(List metricPublishers, MetricCollector apiCallMetricCollector, PutJobSuccessResultResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putJobFailureResult$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobFailureResult$122(List metricPublishers, MetricCollector apiCallMetricCollector, PutJobFailureResultResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putApprovalResult$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putApprovalResult$118(List metricPublishers, MetricCollector apiCallMetricCollector, PutApprovalResultResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putActionRevision$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putActionRevision$114(List metricPublishers, MetricCollector apiCallMetricCollector, PutActionRevisionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$pollForThirdPartyJobs$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForThirdPartyJobs$110(List metricPublishers, MetricCollector apiCallMetricCollector, PollForThirdPartyJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$pollForJobs$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForJobs$106(List metricPublishers, MetricCollector apiCallMetricCollector, PollForJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$overrideStageCondition$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$overrideStageCondition$102(List metricPublishers, MetricCollector apiCallMetricCollector, OverrideStageConditionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWebhooks$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWebhooks$98(List metricPublishers, MetricCollector apiCallMetricCollector, ListWebhooksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$94(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRuleTypes$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleTypes$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListRuleTypesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRuleExecutions$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleExecutions$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListRuleExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPipelines$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelines$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListPipelinesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPipelineExecutions$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelineExecutions$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListPipelineExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDeployActionExecutionTargets$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDeployActionExecutionTargets$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListDeployActionExecutionTargetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listActionTypes$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActionTypes$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListActionTypesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listActionExecutions$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActionExecutions$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListActionExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getThirdPartyJobDetails$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getThirdPartyJobDetails$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetThirdPartyJobDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPipelineState$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineState$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetPipelineStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPipelineExecution$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineExecution$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetPipelineExecutionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPipeline$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipeline$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetPipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobDetails$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobDetails$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getActionType$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActionType$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetActionTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableStageTransition$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableStageTransition$38(List metricPublishers, MetricCollector apiCallMetricCollector, EnableStageTransitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableStageTransition$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableStageTransition$34(List metricPublishers, MetricCollector apiCallMetricCollector, DisableStageTransitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterWebhookWithThirdParty$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterWebhookWithThirdParty$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterWebhookWithThirdPartyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteWebhook$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWebhook$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteWebhookResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePipeline$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipeline$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomActionType$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomActionType$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomActionTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPipeline$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipeline$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomActionType$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomActionType$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomActionTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$acknowledgeThirdPartyJob$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acknowledgeThirdPartyJob$6(List metricPublishers, MetricCollector apiCallMetricCollector, AcknowledgeThirdPartyJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$acknowledgeJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acknowledgeJob$2(List metricPublishers, MetricCollector apiCallMetricCollector, AcknowledgeJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

