/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail;

public class ListRuleExecutionsPublisher
implements SdkPublisher<ListRuleExecutionsResponse> {
    private final CodePipelineAsyncClient client;
    private final ListRuleExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRuleExecutionsPublisher(CodePipelineAsyncClient client, ListRuleExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRuleExecutionsPublisher(CodePipelineAsyncClient client, ListRuleExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRuleExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRuleExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RuleExecutionDetail> ruleExecutionDetails() {
        Function<ListRuleExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleExecutionDetails() != null) {
                return response.ruleExecutionDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRuleExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRuleExecutionsResponseFetcher
    implements AsyncPageFetcher<ListRuleExecutionsResponse> {
        private ListRuleExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRuleExecutionsResponse> nextPage(ListRuleExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListRuleExecutionsPublisher.this.client.listRuleExecutions(ListRuleExecutionsPublisher.this.firstRequest);
            }
            return ListRuleExecutionsPublisher.this.client.listRuleExecutions((ListRuleExecutionsRequest)((Object)ListRuleExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

